/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: VM_BytecodeAction
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class VM_BytecodeAction {

	// VM Constants

	public static final long SIZEOF;
	public static final long EXECUTE_BYTECODE;
	public static final long FALL_THROUGH;
	public static final long GOTO_ASYNC_CHECK;
	public static final long GOTO_BRANCH_WITH_ASYNC_CHECK;
	public static final long GOTO_DONE;
	public static final long GOTO_EXECUTE_BREAKPOINTED_BYTECODE;
	public static final long GOTO_JAVA_STACK_OVERFLOW;
	public static final long GOTO_NOUPDATE;
	public static final long GOTO_RUN_METHOD;
	public static final long GOTO_RUN_METHODHANDLE;
	public static final long GOTO_RUN_METHODHANDLE_COMPILED;
	public static final long GOTO_RUN_METHOD_FROM_METHOD_HANDLE;
	public static final long GOTO_THROW_CURRENT_EXCEPTION;
	public static final long HANDLE_POP_FRAMES;
	public static final long PERFORM_DLT;
	public static final long REPORT_METHOD_ENTER;
	public static final long RUN_JNI_NATIVE;
	public static final long RUN_METHOD_COMPILED;
	public static final long RUN_METHOD_INTERPRETED;
	public static final long THROW_AIOB;
	public static final long THROW_ARRAY_STORE;
	public static final long THROW_DIVIDE_BY_ZERO;
	public static final long THROW_HEAP_OOM;
	public static final long THROW_ILLEGAL_MONITOR_STATE;
	public static final long THROW_INCOMPATIBLE_CLASS_CHANGE;
	public static final long THROW_MONITOR_ALLOC_FAIL;
	public static final long THROW_NEGATIVE_ARRAY_SIZE;
	public static final long THROW_NPE;
	public static final long THROW_VALUE_TYPE_ILLEGAL_MONITOR_STATE;
	public static final long THROW_WRONG_METHOD_TYPE;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		EXECUTE_BYTECODE = 0;
		FALL_THROUGH = 0;
		GOTO_ASYNC_CHECK = 0;
		GOTO_BRANCH_WITH_ASYNC_CHECK = 0;
		GOTO_DONE = 0;
		GOTO_EXECUTE_BREAKPOINTED_BYTECODE = 0;
		GOTO_JAVA_STACK_OVERFLOW = 0;
		GOTO_NOUPDATE = 0;
		GOTO_RUN_METHOD = 0;
		GOTO_RUN_METHODHANDLE = 0;
		GOTO_RUN_METHODHANDLE_COMPILED = 0;
		GOTO_RUN_METHOD_FROM_METHOD_HANDLE = 0;
		GOTO_THROW_CURRENT_EXCEPTION = 0;
		HANDLE_POP_FRAMES = 0;
		PERFORM_DLT = 0;
		REPORT_METHOD_ENTER = 0;
		RUN_JNI_NATIVE = 0;
		RUN_METHOD_COMPILED = 0;
		RUN_METHOD_INTERPRETED = 0;
		THROW_AIOB = 0;
		THROW_ARRAY_STORE = 0;
		THROW_DIVIDE_BY_ZERO = 0;
		THROW_HEAP_OOM = 0;
		THROW_ILLEGAL_MONITOR_STATE = 0;
		THROW_INCOMPATIBLE_CLASS_CHANGE = 0;
		THROW_MONITOR_ALLOC_FAIL = 0;
		THROW_NEGATIVE_ARRAY_SIZE = 0;
		THROW_NPE = 0;
		THROW_VALUE_TYPE_ILLEGAL_MONITOR_STATE = 0;
		THROW_WRONG_METHOD_TYPE = 0;
	}

}
