/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: UtSubtype
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class UtSubtype {

	// VM Constants

	public static final long SIZEOF;
	public static final long UT_ESA;
	public static final long UT_GIGAPROCESSOR;
	public static final long UT_I486;
	public static final long UT_I586;
	public static final long UT_MCKINLEY;
	public static final long UT_MERCED;
	public static final long UT_OPTERON;
	public static final long UT_PII;
	public static final long UT_PIII;
	public static final long UT_PIV;
	public static final long UT_POWERPC;
	public static final long UT_POWERRS;
	public static final long UT_RV64G;
	public static final long UT_SUBTYPE_FORCE_INTEGER;
	public static final long UT_TREX;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		UT_ESA = 0;
		UT_GIGAPROCESSOR = 0;
		UT_I486 = 0;
		UT_I586 = 0;
		UT_MCKINLEY = 0;
		UT_MERCED = 0;
		UT_OPTERON = 0;
		UT_PII = 0;
		UT_PIII = 0;
		UT_PIV = 0;
		UT_POWERPC = 0;
		UT_POWERRS = 0;
		UT_RV64G = 0;
		UT_SUBTYPE_FORCE_INTEGER = 0;
		UT_TREX = 0;
	}

}
