/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: UnitTest
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class UnitTest {

	// VM Constants

	public static final long SIZEOF;
	public static final long ATTACHED_DATA_CORRUPT_COUNT_TEST;
	public static final long ATTACHED_DATA_TEST;
	public static final long ATTACHED_DATA_UPDATE_COUNT_TEST;
	public static final long BYTE_DATA_TEST;
	public static final long CACHE_FULL_TEST;
	public static final long COMPILED_METHOD_TEST;
	public static final long COMPOSITE_CACHE_SIZES_TEST;
	public static final long COMPOSITE_CACHE_TEST;
	public static final long COMPOSITE_CACHE_TEST_SKIP_WRITE_COUNTER_UPDATE;
	public static final long CORRUPT_CACHE_TEST;
	public static final long MINMAX_TEST;
	public static final long NO_TEST;
	public static final long OSCACHE_TEST;
	public static final long PROTECTA_SHARED_CACHE_DATA_TEST;
	public static final long PROTECT_NEW_ROMCLASS_DATA_TEST;
	public static final long SHAREDCACHE_API_TEST;
	public static final long STARTUP_HINTS_TEST;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		ATTACHED_DATA_CORRUPT_COUNT_TEST = 0;
		ATTACHED_DATA_TEST = 0;
		ATTACHED_DATA_UPDATE_COUNT_TEST = 0;
		BYTE_DATA_TEST = 0;
		CACHE_FULL_TEST = 0;
		COMPILED_METHOD_TEST = 0;
		COMPOSITE_CACHE_SIZES_TEST = 0;
		COMPOSITE_CACHE_TEST = 0;
		COMPOSITE_CACHE_TEST_SKIP_WRITE_COUNTER_UPDATE = 0;
		CORRUPT_CACHE_TEST = 0;
		MINMAX_TEST = 0;
		NO_TEST = 0;
		OSCACHE_TEST = 0;
		PROTECTA_SHARED_CACHE_DATA_TEST = 0;
		PROTECT_NEW_ROMCLASS_DATA_TEST = 0;
		SHAREDCACHE_API_TEST = 0;
		STARTUP_HINTS_TEST = 0;
	}

}
