/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: ShcdatatypesConstants
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class ShcdatatypesConstants {

	// VM Constants

	public static final long SIZEOF;
	public static final long CPW_NOT_STALE;
	public static final long MAX_DATA_TYPES;
	public static final long SHC_DOUBLEALIGN;
	public static final long SHC_WORDALIGN;
	public static final long TYPE_ATTACHED_DATA;
	public static final long TYPE_BYTE_DATA;
	public static final long TYPE_CACHELET;
	public static final long TYPE_CLASSPATH;
	public static final long TYPE_COMPILED_METHOD;
	public static final long TYPE_INVALIDATED_COMPILED_METHOD;
	public static final long TYPE_ORPHAN;
	public static final long TYPE_PREREQ_CACHE;
	public static final long TYPE_ROMCLASS;
	public static final long TYPE_SCOPE;
	public static final long TYPE_SCOPED_ROMCLASS;
	public static final long TYPE_UNINDEXED_BYTE_DATA;
	public static final long TYPE_UNINITIALIZED;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		CPW_NOT_STALE = 0;
		MAX_DATA_TYPES = 0;
		SHC_DOUBLEALIGN = 0;
		SHC_WORDALIGN = 0;
		TYPE_ATTACHED_DATA = 0;
		TYPE_BYTE_DATA = 0;
		TYPE_CACHELET = 0;
		TYPE_CLASSPATH = 0;
		TYPE_COMPILED_METHOD = 0;
		TYPE_INVALIDATED_COMPILED_METHOD = 0;
		TYPE_ORPHAN = 0;
		TYPE_PREREQ_CACHE = 0;
		TYPE_ROMCLASS = 0;
		TYPE_SCOPE = 0;
		TYPE_SCOPED_ROMCLASS = 0;
		TYPE_UNINDEXED_BYTE_DATA = 0;
		TYPE_UNINITIALIZED = 0;
	}

}
