/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: ShCFlags
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class ShCFlags {

	// VM Constants

	public static final long SIZEOF;
	public static final long J9SHR_ALL_CACHE_FULL_BITS;
	public static final long J9SHR_AOT_METHOD_FLAG_INVALIDATED;
	public static final long J9SHR_AOT_SPACE_FULL;
	public static final long J9SHR_AOT_STORE_ERROR;
	public static final long J9SHR_AOT_STORE_EXISTS;
	public static final long J9SHR_AOT_STORE_FULL;
	public static final long J9SHR_ATTACHED_DATA_NO_FLAGS;
	public static final long J9SHR_ATTACHED_DATA_TYPE_JITHINT;
	public static final long J9SHR_ATTACHED_DATA_TYPE_JITPROFILE;
	public static final long J9SHR_ATTACHED_DATA_TYPE_MAX;
	public static final long J9SHR_ATTACHED_DATA_TYPE_UNKNOWN;
	public static final long J9SHR_AVAILABLE_SPACE_FULL;
	public static final long J9SHR_BLOCK_SPACE_FULL;
	public static final long J9SHR_DATA_TYPE_AOTCLASSCHAIN;
	public static final long J9SHR_DATA_TYPE_AOTHEADER;
	public static final long J9SHR_DATA_TYPE_AOTTHUNK;
	public static final long J9SHR_DATA_TYPE_CACHELET;
	public static final long J9SHR_DATA_TYPE_HELPER;
	public static final long J9SHR_DATA_TYPE_JCL;
	public static final long J9SHR_DATA_TYPE_JITHINT;
	public static final long J9SHR_DATA_TYPE_MAX;
	public static final long J9SHR_DATA_TYPE_POOL;
	public static final long J9SHR_DATA_TYPE_ROMSTRING;
	public static final long J9SHR_DATA_TYPE_STARTUP_HINTS;
	public static final long J9SHR_DATA_TYPE_UNKNOWN;
	public static final long J9SHR_DATA_TYPE_VM;
	public static final long J9SHR_DATA_TYPE_ZIPCACHE;
	public static final long J9SHR_EXTRA_FLAGS_AOT_HEADER_PRESENT;
	public static final long J9SHR_EXTRA_FLAGS_BCI_ENABLED;
	public static final long J9SHR_EXTRA_FLAGS_LINE_NUMBER_CONTENT;
	public static final long J9SHR_EXTRA_FLAGS_MPROTECT_PARTIAL_PAGES;
	public static final long J9SHR_EXTRA_FLAGS_MPROTECT_PARTIAL_PAGES_ON_STARTUP;
	public static final long J9SHR_EXTRA_FLAGS_NO_LINE_NUMBERS;
	public static final long J9SHR_EXTRA_FLAGS_NO_LINE_NUMBER_CONTENT;
	public static final long J9SHR_EXTRA_FLAGS_RESTRICT_CLASSPATHS;
	public static final long J9SHR_HEADER_STRING_TABLE_INITIALIZED;
	public static final long J9SHR_JIT_SPACE_FULL;
	public static final long J9SHR_LOADTYPE_NORMAL;
	public static final long J9SHR_LOADTYPE_NOT_FROM_PATH;
	public static final long J9SHR_LOADTYPE_REDEFINED;
	public static final long J9SHR_LOADTYPE_RETRANSFORMED;
	public static final long J9SHR_LOCAL_STARTUPHINTS_FLAG_FETCHED;
	public static final long J9SHR_LOCAL_STARTUPHINTS_FLAG_OVERWRITE_HEAPSIZES;
	public static final long J9SHR_LOCAL_STARTUPHINTS_FLAG_OVERWRITE_HINTS;
	public static final long J9SHR_LOCAL_STARTUPHINTS_FLAG_STORE_HEAPSIZES;
	public static final long J9SHR_LOCAL_STARTUPHINTS_FLAG_WRITE_HINTS;
	public static final long J9SHR_MAX_AOT_ADJUSTED;
	public static final long J9SHR_MAX_JIT_ADJUSTED;
	public static final long J9SHR_MIN_AOT_ADJUSTED;
	public static final long J9SHR_MIN_JIT_ADJUSTED;
	public static final long J9SHR_RESOURCE_BUFFER_ALLOC_FAILED;
	public static final long J9SHR_RESOURCE_MAX_ERROR_VALUE;
	public static final long J9SHR_RESOURCE_PARAMETER_ERROR;
	public static final long J9SHR_RESOURCE_STORE_ERROR;
	public static final long J9SHR_RESOURCE_STORE_EXISTS;
	public static final long J9SHR_RESOURCE_STORE_FULL;
	public static final long J9SHR_RESOURCE_STORE_INVALIDATED;
	public static final long J9SHR_RESOURCE_TOO_MANY_UPDATES;
	public static final long J9SHR_RESOURCE_TYPE_UNKNOWN;
	public static final long J9SHR_RUNTIMEFLAG_ADD_TEST_JITHINT;
	public static final long J9SHR_RUNTIMEFLAG_ALLOW_CLASSPATHS;
	public static final long J9SHR_RUNTIMEFLAG_AOT_SPACE_FULL;
	public static final long J9SHR_RUNTIMEFLAG_AUTOKILL_DIFF_BUILDID;
	public static final long J9SHR_RUNTIMEFLAG_AVAILABLE_SPACE_FULL;
	public static final long J9SHR_RUNTIMEFLAG_BLOCK_SPACE_FULL;
	public static final long J9SHR_RUNTIMEFLAG_BYTECODE_AGENT_RUNNING;
	public static final long J9SHR_RUNTIMEFLAG_CACHEDIR_PRESENT;
	public static final long J9SHR_RUNTIMEFLAG_CACHE_INITIALIZATION_COMPLETE;
	public static final long J9SHR_RUNTIMEFLAG_CHECK_STRINGTABLE_RESET_READONLY;
	public static final long J9SHR_RUNTIMEFLAG_CHECK_STRINGTABLE_RESET_READWRITE;
	public static final long J9SHR_RUNTIMEFLAG_CREATE_OLD_GEN;
	public static final long J9SHR_RUNTIMEFLAG_DBG_EXTRA_CHECKS;
	public static final long J9SHR_RUNTIMEFLAG_DENY_CACHE_ACCESS;
	public static final long J9SHR_RUNTIMEFLAG_DENY_CACHE_UPDATES;
	public static final long J9SHR_RUNTIMEFLAG_DETECT_NETWORK_CACHE;
	public static final long J9SHR_RUNTIMEFLAG_DISABLE_BCI;
	public static final long J9SHR_RUNTIMEFLAG_DISABLE_CORRUPT_CACHE_DUMPS;
	public static final long J9SHR_RUNTIMEFLAG_DO_DESTROY_CONFIG;
	public static final long J9SHR_RUNTIMEFLAG_DO_NOT_CREATE_CACHE;
	public static final long J9SHR_RUNTIMEFLAG_DO_RESET_CLASSPATH_CACHE;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_AOT;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_BCI;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_BYTECODEFIX;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_CACHEBOOTCLASSES;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_CACHERETRANSFORMED;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_CACHE_NON_BOOT_CLASSES;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_DETAILED_STATS;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_GROUP_ACCESS;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_JITDATA;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_LOCAL_CACHEING;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_MPROTECT;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_MPROTECT_ALL;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_MPROTECT_ONFIND;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_MPROTECT_PARTIAL_PAGES;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_MPROTECT_RW;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_MSYNC;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_NONFATAL;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_PERSISTENT_CACHE;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_READONLY;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_REDUCE_STORE_CONTENTION;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_ROUND_TO_PAGE_SIZE;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_SEMAPHORE_CHECK;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_SHAREANONYMOUSCLASSES;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_SHAREUNSAFECLASSES;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_STATS;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_STORAGEKEY_TESTING;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_STRING_TABLE_CHECK;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_TEST_BAD_BUILDID;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_TIMESTAMP_CHECKS;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_TRACECOUNT;
	public static final long J9SHR_RUNTIMEFLAG_ENABLE_URL_TIMESTAMP_CHECK;
	public static final long J9SHR_RUNTIMEFLAG_FAKE_CORRUPTION;
	public static final long J9SHR_RUNTIMEFLAG_FORCE_DUMP_IF_CORRUPT;
	public static final long J9SHR_RUNTIMEFLAG_JIT_SPACE_FULL;
	public static final long J9SHR_RUNTIMEFLAG_MPROTECT_PARTIAL_PAGES_ON_STARTUP;
	public static final long J9SHR_RUNTIMEFLAG_NO_PERSISTENT_DISK_SPACE_CHECK;
	public static final long J9SHR_RUNTIMEFLAG_PERSISTENT_KEYWORD;
	public static final long J9SHR_RUNTIMEFLAG_RESTORE;
	public static final long J9SHR_RUNTIMEFLAG_RESTORE_CHECK;
	public static final long J9SHR_RUNTIMEFLAG_RESTRICT_CLASSPATHS;
	public static final long J9SHR_RUNTIMEFLAG_SNAPSHOT;
	public static final long J9SHR_RUNTIMEFLAG_VERIFY_TREE_AND_TREE_ACCESS;
	public static final long J9SHR_SOFTMX_ADJUSTED;
	public static final long J9SHR_STARTUPHINTS_HEAPSIZES_SET;
	public static final long J9SHR_VERBOSEFLAG_ENABLE_VERBOSE;
	public static final long J9SHR_VERBOSEFLAG_ENABLE_VERBOSE_AOT;
	public static final long J9SHR_VERBOSEFLAG_ENABLE_VERBOSE_DATA;
	public static final long J9SHR_VERBOSEFLAG_ENABLE_VERBOSE_DEFAULT;
	public static final long J9SHR_VERBOSEFLAG_ENABLE_VERBOSE_HELPER;
	public static final long J9SHR_VERBOSEFLAG_ENABLE_VERBOSE_INTERN;
	public static final long J9SHR_VERBOSEFLAG_ENABLE_VERBOSE_IO;
	public static final long J9SHR_VERBOSEFLAG_ENABLE_VERBOSE_JITDATA;
	public static final long J9SHR_VERBOSEFLAG_ENABLE_VERBOSE_PAGES;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		J9SHR_ALL_CACHE_FULL_BITS = 0;
		J9SHR_AOT_METHOD_FLAG_INVALIDATED = 0;
		J9SHR_AOT_SPACE_FULL = 0;
		J9SHR_AOT_STORE_ERROR = 0;
		J9SHR_AOT_STORE_EXISTS = 0;
		J9SHR_AOT_STORE_FULL = 0;
		J9SHR_ATTACHED_DATA_NO_FLAGS = 0;
		J9SHR_ATTACHED_DATA_TYPE_JITHINT = 0;
		J9SHR_ATTACHED_DATA_TYPE_JITPROFILE = 0;
		J9SHR_ATTACHED_DATA_TYPE_MAX = 0;
		J9SHR_ATTACHED_DATA_TYPE_UNKNOWN = 0;
		J9SHR_AVAILABLE_SPACE_FULL = 0;
		J9SHR_BLOCK_SPACE_FULL = 0;
		J9SHR_DATA_TYPE_AOTCLASSCHAIN = 0;
		J9SHR_DATA_TYPE_AOTHEADER = 0;
		J9SHR_DATA_TYPE_AOTTHUNK = 0;
		J9SHR_DATA_TYPE_CACHELET = 0;
		J9SHR_DATA_TYPE_HELPER = 0;
		J9SHR_DATA_TYPE_JCL = 0;
		J9SHR_DATA_TYPE_JITHINT = 0;
		J9SHR_DATA_TYPE_MAX = 0;
		J9SHR_DATA_TYPE_POOL = 0;
		J9SHR_DATA_TYPE_ROMSTRING = 0;
		J9SHR_DATA_TYPE_STARTUP_HINTS = 0;
		J9SHR_DATA_TYPE_UNKNOWN = 0;
		J9SHR_DATA_TYPE_VM = 0;
		J9SHR_DATA_TYPE_ZIPCACHE = 0;
		J9SHR_EXTRA_FLAGS_AOT_HEADER_PRESENT = 0;
		J9SHR_EXTRA_FLAGS_BCI_ENABLED = 0;
		J9SHR_EXTRA_FLAGS_LINE_NUMBER_CONTENT = 0;
		J9SHR_EXTRA_FLAGS_MPROTECT_PARTIAL_PAGES = 0;
		J9SHR_EXTRA_FLAGS_MPROTECT_PARTIAL_PAGES_ON_STARTUP = 0;
		J9SHR_EXTRA_FLAGS_NO_LINE_NUMBERS = 0;
		J9SHR_EXTRA_FLAGS_NO_LINE_NUMBER_CONTENT = 0;
		J9SHR_EXTRA_FLAGS_RESTRICT_CLASSPATHS = 0;
		J9SHR_HEADER_STRING_TABLE_INITIALIZED = 0;
		J9SHR_JIT_SPACE_FULL = 0;
		J9SHR_LOADTYPE_NORMAL = 0;
		J9SHR_LOADTYPE_NOT_FROM_PATH = 0;
		J9SHR_LOADTYPE_REDEFINED = 0;
		J9SHR_LOADTYPE_RETRANSFORMED = 0;
		J9SHR_LOCAL_STARTUPHINTS_FLAG_FETCHED = 0;
		J9SHR_LOCAL_STARTUPHINTS_FLAG_OVERWRITE_HEAPSIZES = 0;
		J9SHR_LOCAL_STARTUPHINTS_FLAG_OVERWRITE_HINTS = 0;
		J9SHR_LOCAL_STARTUPHINTS_FLAG_STORE_HEAPSIZES = 0;
		J9SHR_LOCAL_STARTUPHINTS_FLAG_WRITE_HINTS = 0;
		J9SHR_MAX_AOT_ADJUSTED = 0;
		J9SHR_MAX_JIT_ADJUSTED = 0;
		J9SHR_MIN_AOT_ADJUSTED = 0;
		J9SHR_MIN_JIT_ADJUSTED = 0;
		J9SHR_RESOURCE_BUFFER_ALLOC_FAILED = 0;
		J9SHR_RESOURCE_MAX_ERROR_VALUE = 0;
		J9SHR_RESOURCE_PARAMETER_ERROR = 0;
		J9SHR_RESOURCE_STORE_ERROR = 0;
		J9SHR_RESOURCE_STORE_EXISTS = 0;
		J9SHR_RESOURCE_STORE_FULL = 0;
		J9SHR_RESOURCE_STORE_INVALIDATED = 0;
		J9SHR_RESOURCE_TOO_MANY_UPDATES = 0;
		J9SHR_RESOURCE_TYPE_UNKNOWN = 0;
		J9SHR_RUNTIMEFLAG_ADD_TEST_JITHINT = 0;
		J9SHR_RUNTIMEFLAG_ALLOW_CLASSPATHS = 0;
		J9SHR_RUNTIMEFLAG_AOT_SPACE_FULL = 0;
		J9SHR_RUNTIMEFLAG_AUTOKILL_DIFF_BUILDID = 0;
		J9SHR_RUNTIMEFLAG_AVAILABLE_SPACE_FULL = 0;
		J9SHR_RUNTIMEFLAG_BLOCK_SPACE_FULL = 0;
		J9SHR_RUNTIMEFLAG_BYTECODE_AGENT_RUNNING = 0;
		J9SHR_RUNTIMEFLAG_CACHEDIR_PRESENT = 0;
		J9SHR_RUNTIMEFLAG_CACHE_INITIALIZATION_COMPLETE = 0;
		J9SHR_RUNTIMEFLAG_CHECK_STRINGTABLE_RESET_READONLY = 0;
		J9SHR_RUNTIMEFLAG_CHECK_STRINGTABLE_RESET_READWRITE = 0;
		J9SHR_RUNTIMEFLAG_CREATE_OLD_GEN = 0;
		J9SHR_RUNTIMEFLAG_DBG_EXTRA_CHECKS = 0;
		J9SHR_RUNTIMEFLAG_DENY_CACHE_ACCESS = 0;
		J9SHR_RUNTIMEFLAG_DENY_CACHE_UPDATES = 0;
		J9SHR_RUNTIMEFLAG_DETECT_NETWORK_CACHE = 0;
		J9SHR_RUNTIMEFLAG_DISABLE_BCI = 0;
		J9SHR_RUNTIMEFLAG_DISABLE_CORRUPT_CACHE_DUMPS = 0;
		J9SHR_RUNTIMEFLAG_DO_DESTROY_CONFIG = 0;
		J9SHR_RUNTIMEFLAG_DO_NOT_CREATE_CACHE = 0;
		J9SHR_RUNTIMEFLAG_DO_RESET_CLASSPATH_CACHE = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_AOT = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_BCI = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_BYTECODEFIX = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_CACHEBOOTCLASSES = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_CACHERETRANSFORMED = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_CACHE_NON_BOOT_CLASSES = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_DETAILED_STATS = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_GROUP_ACCESS = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_JITDATA = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_LOCAL_CACHEING = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_MPROTECT = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_MPROTECT_ALL = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_MPROTECT_ONFIND = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_MPROTECT_PARTIAL_PAGES = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_MPROTECT_RW = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_MSYNC = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_NONFATAL = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_PERSISTENT_CACHE = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_READONLY = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_REDUCE_STORE_CONTENTION = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_ROUND_TO_PAGE_SIZE = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_SEMAPHORE_CHECK = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_SHAREANONYMOUSCLASSES = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_SHAREUNSAFECLASSES = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_STATS = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_STORAGEKEY_TESTING = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_STRING_TABLE_CHECK = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_TEST_BAD_BUILDID = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_TIMESTAMP_CHECKS = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_TRACECOUNT = 0;
		J9SHR_RUNTIMEFLAG_ENABLE_URL_TIMESTAMP_CHECK = 0;
		J9SHR_RUNTIMEFLAG_FAKE_CORRUPTION = 0;
		J9SHR_RUNTIMEFLAG_FORCE_DUMP_IF_CORRUPT = 0;
		J9SHR_RUNTIMEFLAG_JIT_SPACE_FULL = 0;
		J9SHR_RUNTIMEFLAG_MPROTECT_PARTIAL_PAGES_ON_STARTUP = 0;
		J9SHR_RUNTIMEFLAG_NO_PERSISTENT_DISK_SPACE_CHECK = 0;
		J9SHR_RUNTIMEFLAG_PERSISTENT_KEYWORD = 0;
		J9SHR_RUNTIMEFLAG_RESTORE = 0;
		J9SHR_RUNTIMEFLAG_RESTORE_CHECK = 0;
		J9SHR_RUNTIMEFLAG_RESTRICT_CLASSPATHS = 0;
		J9SHR_RUNTIMEFLAG_SNAPSHOT = 0;
		J9SHR_RUNTIMEFLAG_VERIFY_TREE_AND_TREE_ACCESS = 0;
		J9SHR_SOFTMX_ADJUSTED = 0;
		J9SHR_STARTUPHINTS_HEAPSIZES_SET = 0;
		J9SHR_VERBOSEFLAG_ENABLE_VERBOSE = 0;
		J9SHR_VERBOSEFLAG_ENABLE_VERBOSE_AOT = 0;
		J9SHR_VERBOSEFLAG_ENABLE_VERBOSE_DATA = 0;
		J9SHR_VERBOSEFLAG_ENABLE_VERBOSE_DEFAULT = 0;
		J9SHR_VERBOSEFLAG_ENABLE_VERBOSE_HELPER = 0;
		J9SHR_VERBOSEFLAG_ENABLE_VERBOSE_INTERN = 0;
		J9SHR_VERBOSEFLAG_ENABLE_VERBOSE_IO = 0;
		J9SHR_VERBOSEFLAG_ENABLE_VERBOSE_JITDATA = 0;
		J9SHR_VERBOSEFLAG_ENABLE_VERBOSE_PAGES = 0;
	}

}
