/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: SH_CacheMap
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class SH_CacheMap {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __actualSizeOffset_;
	public static final int __admOffset_;
	public static final int __bdmOffset_;
	public static final int __bytesReadOffset_;
	public static final int __cacheAddressRangeArrayOffset_;
	public static final int __cacheCorruptReportedOffset_;
	public static final int __cacheDirOffset_;
	public static final int __cacheNameOffset_;
	public static final int __ccOffset_;
	public static final int __ccHeadOffset_;
	public static final int __ccPoolOffset_;
	public static final int __ccTailOffset_;
	public static final int __cmmOffset_;
	public static final int __cpmOffset_;
	public static final int __isAssertEnabledOffset_;
	public static final int __localCrashCntrOffset_;
	public static final int __managersOffset_;
	public static final int __metadataReleasedOffset_;
	public static final int __numOfCacheLayersOffset_;
	public static final int __portlibOffset_;
	public static final int __rcmOffset_;
	public static final int __readOnlyCacheRuntimeFlagsOffset_;
	public static final int __refreshMutexOffset_;
	public static final int __runtimeFlagsOffset_;
	public static final int __scmOffset_;
	public static final int __sharedClassConfigOffset_;
	public static final int __tsmOffset_;
	public static final int __verboseFlagsOffset_;
	public static final int __writeHashAverageTimeMicrosOffset_;
	public static final int __writeHashContendedResetHashOffset_;
	public static final int __writeHashMaxWaitMicrosOffset_;
	public static final int __writeHashSavedMaxWaitMicrosOffset_;
	public static final int __writeHashStartTimeOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__actualSizeOffset_ = 0;
		__admOffset_ = 0;
		__bdmOffset_ = 0;
		__bytesReadOffset_ = 0;
		__cacheAddressRangeArrayOffset_ = 0;
		__cacheCorruptReportedOffset_ = 0;
		__cacheDirOffset_ = 0;
		__cacheNameOffset_ = 0;
		__ccOffset_ = 0;
		__ccHeadOffset_ = 0;
		__ccPoolOffset_ = 0;
		__ccTailOffset_ = 0;
		__cmmOffset_ = 0;
		__cpmOffset_ = 0;
		__isAssertEnabledOffset_ = 0;
		__localCrashCntrOffset_ = 0;
		__managersOffset_ = 0;
		__metadataReleasedOffset_ = 0;
		__numOfCacheLayersOffset_ = 0;
		__portlibOffset_ = 0;
		__rcmOffset_ = 0;
		__readOnlyCacheRuntimeFlagsOffset_ = 0;
		__refreshMutexOffset_ = 0;
		__runtimeFlagsOffset_ = 0;
		__scmOffset_ = 0;
		__sharedClassConfigOffset_ = 0;
		__tsmOffset_ = 0;
		__verboseFlagsOffset_ = 0;
		__writeHashAverageTimeMicrosOffset_ = 0;
		__writeHashContendedResetHashOffset_ = 0;
		__writeHashMaxWaitMicrosOffset_ = 0;
		__writeHashSavedMaxWaitMicrosOffset_ = 0;
		__writeHashStartTimeOffset_ = 0;
	}

}
