/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: ROMClassCreationPhase
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class ROMClassCreationPhase {

	// VM Constants

	public static final long SIZEOF;
	public static final long CheckForLoop;
	public static final long ClassFileAnalysis;
	public static final long ClassFileAnnotationElementAnalysis;
	public static final long ClassFileAnnotationsAnalysis;
	public static final long ClassFileAttributesAnalysis;
	public static final long ClassFileAttributesRecordAnalysis;
	public static final long ClassFileFieldsAnalysis;
	public static final long ClassFileHeaderAnalysis;
	public static final long ClassFileInterfacesAnalysis;
	public static final long ClassFileMethodAttributesAnalysis;
	public static final long ClassFileMethodCodeAttributeAnalysis;
	public static final long ClassFileMethodCodeAttributeAttributesAnalysis;
	public static final long ClassFileMethodCodeAttributeCaughtExceptionsAnalysis;
	public static final long ClassFileMethodCodeAttributeCodeAnalysis;
	public static final long ClassFileMethodMethodParametersAttributeAnalysis;
	public static final long ClassFileMethodThrownExceptionsAnalysis;
	public static final long ClassFileMethodsAnalysis;
	public static final long ClassFileStackMapSlotsAnalysis;
	public static final long CompareHashtableROMClass;
	public static final long CompareSharedROMClass;
	public static final long CompressLineNumbers;
	public static final long ComputeExtraModifiers;
	public static final long ComputeOptionalFlags;
	public static final long ComputeSendSlotCount;
	public static final long ConstantPoolMapping;
	public static final long CreateSharedClass;
	public static final long LayDownROMClass;
	public static final long MarkAndCountUTF8s;
	public static final long MethodIsEmpty;
	public static final long MethodIsFinalize;
	public static final long MethodIsForwarder;
	public static final long MethodIsGetter;
	public static final long MethodIsNonStaticNonAbstract;
	public static final long MethodIsObjectConstructor;
	public static final long MethodIsVirtual;
	public static final long ParseClassFile;
	public static final long ParseClassFileAttributes;
	public static final long ParseClassFileCheckClass;
	public static final long ParseClassFileConstantPool;
	public static final long ParseClassFileFields;
	public static final long ParseClassFileInlineJSRs;
	public static final long ParseClassFileMethods;
	public static final long ParseClassFileVerifyClass;
	public static final long PrepareROMClass;
	public static final long PrepareUTF8sAfterInternsMarked;
	public static final long ROMClassCreation;
	public static final long ROMClassCreationPhaseCount;
	public static final long ROMClassPrepareAndLayDown;
	public static final long ROMClassTranslation;
	public static final long SRPOffsetTableCreation;
	public static final long ShouldConvertInvokeVirtualToInvokeSpecial;
	public static final long VisitUTF8Block;
	public static final long WalkUTF8sAndMarkInterns;
	public static final long WriteUTF8s;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		CheckForLoop = 0;
		ClassFileAnalysis = 0;
		ClassFileAnnotationElementAnalysis = 0;
		ClassFileAnnotationsAnalysis = 0;
		ClassFileAttributesAnalysis = 0;
		ClassFileAttributesRecordAnalysis = 0;
		ClassFileFieldsAnalysis = 0;
		ClassFileHeaderAnalysis = 0;
		ClassFileInterfacesAnalysis = 0;
		ClassFileMethodAttributesAnalysis = 0;
		ClassFileMethodCodeAttributeAnalysis = 0;
		ClassFileMethodCodeAttributeAttributesAnalysis = 0;
		ClassFileMethodCodeAttributeCaughtExceptionsAnalysis = 0;
		ClassFileMethodCodeAttributeCodeAnalysis = 0;
		ClassFileMethodMethodParametersAttributeAnalysis = 0;
		ClassFileMethodThrownExceptionsAnalysis = 0;
		ClassFileMethodsAnalysis = 0;
		ClassFileStackMapSlotsAnalysis = 0;
		CompareHashtableROMClass = 0;
		CompareSharedROMClass = 0;
		CompressLineNumbers = 0;
		ComputeExtraModifiers = 0;
		ComputeOptionalFlags = 0;
		ComputeSendSlotCount = 0;
		ConstantPoolMapping = 0;
		CreateSharedClass = 0;
		LayDownROMClass = 0;
		MarkAndCountUTF8s = 0;
		MethodIsEmpty = 0;
		MethodIsFinalize = 0;
		MethodIsForwarder = 0;
		MethodIsGetter = 0;
		MethodIsNonStaticNonAbstract = 0;
		MethodIsObjectConstructor = 0;
		MethodIsVirtual = 0;
		ParseClassFile = 0;
		ParseClassFileAttributes = 0;
		ParseClassFileCheckClass = 0;
		ParseClassFileConstantPool = 0;
		ParseClassFileFields = 0;
		ParseClassFileInlineJSRs = 0;
		ParseClassFileMethods = 0;
		ParseClassFileVerifyClass = 0;
		PrepareROMClass = 0;
		PrepareUTF8sAfterInternsMarked = 0;
		ROMClassCreation = 0;
		ROMClassCreationPhaseCount = 0;
		ROMClassPrepareAndLayDown = 0;
		ROMClassTranslation = 0;
		SRPOffsetTableCreation = 0;
		ShouldConvertInvokeVirtualToInvokeSpecial = 0;
		VisitUTF8Block = 0;
		WalkUTF8sAndMarkInterns = 0;
		WriteUTF8s = 0;
	}

}
