/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: PreviousTimes
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class PreviousTimes {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _allocationFailureOffset_;
	public static final int _balancedGlobalGCOffset_;
	public static final int _concurrentGCOffset_;
	public static final int _exclusiveAccessEndOffset_;
	public static final int _exclusiveAccessStartOffset_;
	public static final int _globalGCOffset_;
	public static final int _globalMarkGCOffset_;
	public static final int _initializedOffset_;
	public static final int _localGCOffset_;
	public static final int _metronomeCycleEndOffset_;
	public static final int _metronomeCycleStartOffset_;
	public static final int _metronomeHeartbeatOffset_;
	public static final int _metronomeSynchGCOffset_;
	public static final int _metronomeThreadPriorityChangeOffset_;
	public static final int _metronomeTriggerEndOffset_;
	public static final int _metronomeTriggerStartOffset_;
	public static final int _nurseryAFOffset_;
	public static final int _partialGCOffset_;
	public static final int _systemGCOffset_;
	public static final int _tarokIncrementEndOffset_;
	public static final int _tarokIncrementStartOffset_;
	public static final int _taxationEntryPointOffset_;
	public static final int _tenureAFOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_allocationFailureOffset_ = 0;
		_balancedGlobalGCOffset_ = 0;
		_concurrentGCOffset_ = 0;
		_exclusiveAccessEndOffset_ = 0;
		_exclusiveAccessStartOffset_ = 0;
		_globalGCOffset_ = 0;
		_globalMarkGCOffset_ = 0;
		_initializedOffset_ = 0;
		_localGCOffset_ = 0;
		_metronomeCycleEndOffset_ = 0;
		_metronomeCycleStartOffset_ = 0;
		_metronomeHeartbeatOffset_ = 0;
		_metronomeSynchGCOffset_ = 0;
		_metronomeThreadPriorityChangeOffset_ = 0;
		_metronomeTriggerEndOffset_ = 0;
		_metronomeTriggerStartOffset_ = 0;
		_nurseryAFOffset_ = 0;
		_partialGCOffset_ = 0;
		_systemGCOffset_ = 0;
		_tarokIncrementEndOffset_ = 0;
		_tarokIncrementStartOffset_ = 0;
		_taxationEntryPointOffset_ = 0;
		_tenureAFOffset_ = 0;
	}

}
