/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MethodInfo
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MethodInfo {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _annotationsAttributeOffset_;
	public static final int _byteCodeFixupCountOffset_;
	public static final int _byteCodeFixupTableOffset_;
	public static final int _codeTypeAnnotationsAttributeOffset_;
	public static final int _defaultAnnotationAttributeOffset_;
	public static final int _exceptionsThrownCountOffset_;
	public static final int _extendedModifiersOffset_;
	public static final int _genericSignatureIndexOffset_;
	public static final int _hasFrameIteratorSkipAnnotationOffset_;
	public static final int _isByteCodeFixupDoneOffset_;
	public static final int _lineNumbersCountOffset_;
	public static final int _lineNumbersInfoCompressedOffset_;
	public static final int _lineNumbersInfoCompressedSizeOffset_;
	public static final int _localVariablesCountOffset_;
	public static final int _localVariablesInfoOffset_;
	public static final int _methodParametersAttributeOffset_;
	public static final int _methodTypeAnnotationsAttributeOffset_;
	public static final int _modifiersOffset_;
	public static final int _parameterAnnotationsAttributeOffset_;
	public static final int _sendSlotCountOffset_;
	public static final int _stackMapFramesCountOffset_;
	public static final int _stackMapFramesInfoOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_annotationsAttributeOffset_ = 0;
		_byteCodeFixupCountOffset_ = 0;
		_byteCodeFixupTableOffset_ = 0;
		_codeTypeAnnotationsAttributeOffset_ = 0;
		_defaultAnnotationAttributeOffset_ = 0;
		_exceptionsThrownCountOffset_ = 0;
		_extendedModifiersOffset_ = 0;
		_genericSignatureIndexOffset_ = 0;
		_hasFrameIteratorSkipAnnotationOffset_ = 0;
		_isByteCodeFixupDoneOffset_ = 0;
		_lineNumbersCountOffset_ = 0;
		_lineNumbersInfoCompressedOffset_ = 0;
		_lineNumbersInfoCompressedSizeOffset_ = 0;
		_localVariablesCountOffset_ = 0;
		_localVariablesInfoOffset_ = 0;
		_methodParametersAttributeOffset_ = 0;
		_methodTypeAnnotationsAttributeOffset_ = 0;
		_modifiersOffset_ = 0;
		_parameterAnnotationsAttributeOffset_ = 0;
		_sendSlotCountOffset_ = 0;
		_stackMapFramesCountOffset_ = 0;
		_stackMapFramesInfoOffset_ = 0;
	}

}
