/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_VerboseEventMetronomeSynchronousGCEnd
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_VerboseEventMetronomeSynchronousGCEnd {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __classLoadersUnloadedEndOffset_;
	public static final int __classLoadersUnloadedStartOffset_;
	public static final int __classesUnloadedEndOffset_;
	public static final int __classesUnloadedStartOffset_;
	public static final int __dynamicSoftReferenceThresholdOffset_;
	public static final int __finalizableCountOffset_;
	public static final int __gcThreadPriorityOffset_;
	public static final int __heapFreeAfterOffset_;
	public static final int __heapFreeBeforeOffset_;
	public static final int __objectOverflowCountOffset_;
	public static final int __phantomReferenceClearCountOffset_;
	public static final int __reasonOffset_;
	public static final int __reasonParameterOffset_;
	public static final int __softReferenceClearCountOffset_;
	public static final int __softReferenceThresholdOffset_;
	public static final int __startTimeOffset_;
	public static final int __timestampOffset_;
	public static final int __weakReferenceClearCountOffset_;
	public static final int __workPacketOverflowCountOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__classLoadersUnloadedEndOffset_ = 0;
		__classLoadersUnloadedStartOffset_ = 0;
		__classesUnloadedEndOffset_ = 0;
		__classesUnloadedStartOffset_ = 0;
		__dynamicSoftReferenceThresholdOffset_ = 0;
		__finalizableCountOffset_ = 0;
		__gcThreadPriorityOffset_ = 0;
		__heapFreeAfterOffset_ = 0;
		__heapFreeBeforeOffset_ = 0;
		__objectOverflowCountOffset_ = 0;
		__phantomReferenceClearCountOffset_ = 0;
		__reasonOffset_ = 0;
		__reasonParameterOffset_ = 0;
		__softReferenceClearCountOffset_ = 0;
		__softReferenceThresholdOffset_ = 0;
		__startTimeOffset_ = 0;
		__timestampOffset_ = 0;
		__weakReferenceClearCountOffset_ = 0;
		__workPacketOverflowCountOffset_ = 0;
	}

}
