/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_VerboseEventLocalGCEnd
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_VerboseEventLocalGCEnd {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __backoutOffset_;
	public static final int __causedRememberedSetOverflowOffset_;
	public static final int __dynamicSoftReferenceThresholdOffset_;
	public static final int __extensionsOffset_;
	public static final int __failedFlipBytesOffset_;
	public static final int __failedFlipCountOffset_;
	public static final int __failedTenureBytesOffset_;
	public static final int __failedTenureCountOffset_;
	public static final int __finalizerCountOffset_;
	public static final int __flipBytesOffset_;
	public static final int __flipCountOffset_;
	public static final int __globalGCCountOffset_;
	public static final int __loaEnabledOffset_;
	public static final int __localGCCountOffset_;
	public static final int __localGCStartTimeOffset_;
	public static final int __nurseryFreeBytesOffset_;
	public static final int __nurseryTotalBytesOffset_;
	public static final int __phantomReferenceClearCountOffset_;
	public static final int __rememberedSetOverflowedOffset_;
	public static final int __scanCacheOverflowOffset_;
	public static final int __softReferenceClearCountOffset_;
	public static final int __softReferenceThresholdOffset_;
	public static final int __tenureAgeOffset_;
	public static final int __tenureBytesOffset_;
	public static final int __tenureCountOffset_;
	public static final int __tenureFreeBytesOffset_;
	public static final int __tenureLOAFreeBytesOffset_;
	public static final int __tenureLOATotalBytesOffset_;
	public static final int __tenureTotalBytesOffset_;
	public static final int __tiltedOffset_;
	public static final int __totalMemorySizeOffset_;
	public static final int __weakReferenceClearCountOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__backoutOffset_ = 0;
		__causedRememberedSetOverflowOffset_ = 0;
		__dynamicSoftReferenceThresholdOffset_ = 0;
		__extensionsOffset_ = 0;
		__failedFlipBytesOffset_ = 0;
		__failedFlipCountOffset_ = 0;
		__failedTenureBytesOffset_ = 0;
		__failedTenureCountOffset_ = 0;
		__finalizerCountOffset_ = 0;
		__flipBytesOffset_ = 0;
		__flipCountOffset_ = 0;
		__globalGCCountOffset_ = 0;
		__loaEnabledOffset_ = 0;
		__localGCCountOffset_ = 0;
		__localGCStartTimeOffset_ = 0;
		__nurseryFreeBytesOffset_ = 0;
		__nurseryTotalBytesOffset_ = 0;
		__phantomReferenceClearCountOffset_ = 0;
		__rememberedSetOverflowedOffset_ = 0;
		__scanCacheOverflowOffset_ = 0;
		__softReferenceClearCountOffset_ = 0;
		__softReferenceThresholdOffset_ = 0;
		__tenureAgeOffset_ = 0;
		__tenureBytesOffset_ = 0;
		__tenureCountOffset_ = 0;
		__tenureFreeBytesOffset_ = 0;
		__tenureLOAFreeBytesOffset_ = 0;
		__tenureLOATotalBytesOffset_ = 0;
		__tenureTotalBytesOffset_ = 0;
		__tiltedOffset_ = 0;
		__totalMemorySizeOffset_ = 0;
		__weakReferenceClearCountOffset_ = 0;
	}

}
