/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_ParallelSweepChunk
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_ParallelSweepChunk {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __accumulatedFreeHolesOffset_;
	public static final int __accumulatedFreeSizeOffset_;
	public static final int __coalesceCandidateOffset_;
	public static final int __concurrentSweepStateOffset_;
	public static final int __darkMatterBytesOffset_;
	public static final int __darkMatterSamplesOffset_;
	public static final int __largestFreeEntryOffset_;
	public static final int __nextOffset_;
	public static final int __nextChunkOffset_;
	public static final int __nonScannableBytesOffset_;
	public static final int __previousOffset_;
	public static final int __previousLargestFreeEntryOffset_;
	public static final int __scannableBytesOffset_;
	public static final int __splitCandidateOffset_;
	public static final int __splitCandidatePreviousEntryOffset_;
	public static final int _chunkBaseOffset_;
	public static final int _chunkTopOffset_;
	public static final int _freeBytesOffset_;
	public static final int _freeHolesOffset_;
	public static final int _freeListHeadOffset_;
	public static final int _freeListHeadSizeOffset_;
	public static final int _freeListTailOffset_;
	public static final int _freeListTailSizeOffset_;
	public static final int _leadingFreeCandidateOffset_;
	public static final int _leadingFreeCandidateSizeOffset_;
	public static final int _memoryPoolOffset_;
	public static final int _previousFreeListTailOffset_;
	public static final int _projectionOffset_;
	public static final int _trailingFreeCandidateOffset_;
	public static final int _trailingFreeCandidateSizeOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__accumulatedFreeHolesOffset_ = 0;
		__accumulatedFreeSizeOffset_ = 0;
		__coalesceCandidateOffset_ = 0;
		__concurrentSweepStateOffset_ = 0;
		__darkMatterBytesOffset_ = 0;
		__darkMatterSamplesOffset_ = 0;
		__largestFreeEntryOffset_ = 0;
		__nextOffset_ = 0;
		__nextChunkOffset_ = 0;
		__nonScannableBytesOffset_ = 0;
		__previousOffset_ = 0;
		__previousLargestFreeEntryOffset_ = 0;
		__scannableBytesOffset_ = 0;
		__splitCandidateOffset_ = 0;
		__splitCandidatePreviousEntryOffset_ = 0;
		_chunkBaseOffset_ = 0;
		_chunkTopOffset_ = 0;
		_freeBytesOffset_ = 0;
		_freeHolesOffset_ = 0;
		_freeListHeadOffset_ = 0;
		_freeListHeadSizeOffset_ = 0;
		_freeListTailOffset_ = 0;
		_freeListTailSizeOffset_ = 0;
		_leadingFreeCandidateOffset_ = 0;
		_leadingFreeCandidateSizeOffset_ = 0;
		_memoryPoolOffset_ = 0;
		_previousFreeListTailOffset_ = 0;
		_projectionOffset_ = 0;
		_trailingFreeCandidateOffset_ = 0;
		_trailingFreeCandidateSizeOffset_ = 0;
	}

}
