/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_MemorySubSpaceSemiSpace
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_MemorySubSpaceSemiSpace {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __allocateSpaceBaseOffset_;
	public static final int __allocateSpaceTopOffset_;
	public static final int __averageScavengeTimeRatioOffset_;
	public static final int __avgBytesAllocatedDuringConcurrentOffset_;
	public static final int __avgDeviationBytesAllocatedDuringConcurrentOffset_;
	public static final int __bytesAllocatedDuringConcurrentOffset_;
	public static final int __desiredSurvivorSpaceRatioOffset_;
	public static final int __deviationBytesAllocatedDuringConcurrentOffset_;
	public static final int __largeObjectAllocateStatsOffset_;
	public static final int __lastScavengeEndTimeOffset_;
	public static final int __memorySubSpaceAllocateOffset_;
	public static final int __memorySubSpaceEvacuateOffset_;
	public static final int __memorySubSpaceSurvivorOffset_;
	public static final int __previousBytesFlippedOffset_;
	public static final int __survivorSpaceBaseOffset_;
	public static final int __survivorSpaceSizeRatioOffset_;
	public static final int __survivorSpaceTopOffset_;
	public static final int __tiltedAverageBytesFlippedOffset_;
	public static final int __tiltedAverageBytesFlippedDeltaOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__allocateSpaceBaseOffset_ = 0;
		__allocateSpaceTopOffset_ = 0;
		__averageScavengeTimeRatioOffset_ = 0;
		__avgBytesAllocatedDuringConcurrentOffset_ = 0;
		__avgDeviationBytesAllocatedDuringConcurrentOffset_ = 0;
		__bytesAllocatedDuringConcurrentOffset_ = 0;
		__desiredSurvivorSpaceRatioOffset_ = 0;
		__deviationBytesAllocatedDuringConcurrentOffset_ = 0;
		__largeObjectAllocateStatsOffset_ = 0;
		__lastScavengeEndTimeOffset_ = 0;
		__memorySubSpaceAllocateOffset_ = 0;
		__memorySubSpaceEvacuateOffset_ = 0;
		__memorySubSpaceSurvivorOffset_ = 0;
		__previousBytesFlippedOffset_ = 0;
		__survivorSpaceBaseOffset_ = 0;
		__survivorSpaceSizeRatioOffset_ = 0;
		__survivorSpaceTopOffset_ = 0;
		__tiltedAverageBytesFlippedOffset_ = 0;
		__tiltedAverageBytesFlippedDeltaOffset_ = 0;
	}

}
