/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_MemorySubSpace
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_MemorySubSpace {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __allocationFailureStatsOffset_;
	public static final int __childrenOffset_;
	public static final int __collectorOffset_;
	public static final int __concurrentCollectableOffset_;
	public static final int __contractionSizeOffset_;
	public static final int __counterBalanceChainOffset_;
	public static final int __counterBalanceChainHeadOffset_;
	public static final int __counterBalanceSizeOffset_;
	public static final int __counterBalanceTypeOffset_;
	public static final int __currentSizeOffset_;
	public static final int __expansionSizeOffset_;
	public static final int __extensionsOffset_;
	public static final int __initialSizeOffset_;
	public static final int __isAllocatableOffset_;
	public static final int __lockOffset_;
	public static final int __maximumSizeOffset_;
	public static final int __memorySpaceOffset_;
	public static final int __memoryTypeOffset_;
	public static final int __minimumSizeOffset_;
	public static final int __nextOffset_;
	public static final int __objectFlagsOffset_;
	public static final int __parentOffset_;
	public static final int __physicalSubArenaOffset_;
	public static final int __previousOffset_;
	public static final int __regionListOffset_;
	public static final int __uniqueIDOffset_;
	public static final int __usesGlobalCollectorOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__allocationFailureStatsOffset_ = 0;
		__childrenOffset_ = 0;
		__collectorOffset_ = 0;
		__concurrentCollectableOffset_ = 0;
		__contractionSizeOffset_ = 0;
		__counterBalanceChainOffset_ = 0;
		__counterBalanceChainHeadOffset_ = 0;
		__counterBalanceSizeOffset_ = 0;
		__counterBalanceTypeOffset_ = 0;
		__currentSizeOffset_ = 0;
		__expansionSizeOffset_ = 0;
		__extensionsOffset_ = 0;
		__initialSizeOffset_ = 0;
		__isAllocatableOffset_ = 0;
		__lockOffset_ = 0;
		__maximumSizeOffset_ = 0;
		__memorySpaceOffset_ = 0;
		__memoryTypeOffset_ = 0;
		__minimumSizeOffset_ = 0;
		__nextOffset_ = 0;
		__objectFlagsOffset_ = 0;
		__parentOffset_ = 0;
		__physicalSubArenaOffset_ = 0;
		__previousOffset_ = 0;
		__regionListOffset_ = 0;
		__uniqueIDOffset_ = 0;
		__usesGlobalCollectorOffset_ = 0;
	}

}
