/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_LocalGCEndEvent
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_LocalGCEndEvent {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _backoutOffset_;
	public static final int _causedRememberedSetOverflowOffset_;
	public static final int _currentThreadOffset_;
	public static final int _eventidOffset_;
	public static final int _failedFlipBytesOffset_;
	public static final int _failedFlipCountOffset_;
	public static final int _failedTenureBytesOffset_;
	public static final int _failedTenureCountOffset_;
	public static final int _flipBytesOffset_;
	public static final int _flipCountOffset_;
	public static final int _globalGCCountOffset_;
	public static final int _loaEnabledOffset_;
	public static final int _localGCCountOffset_;
	public static final int _nurseryFreeBytesOffset_;
	public static final int _nurseryTotalBytesOffset_;
	public static final int _rememberedSetOverflowedOffset_;
	public static final int _scanCacheOverflowOffset_;
	public static final int _subSpaceOffset_;
	public static final int _tenureAgeOffset_;
	public static final int _tenureBytesOffset_;
	public static final int _tenureCountOffset_;
	public static final int _tenureFreeBytesOffset_;
	public static final int _tenureLOAFreeBytesOffset_;
	public static final int _tenureLOATotalBytesOffset_;
	public static final int _tenureTotalBytesOffset_;
	public static final int _tiltedOffset_;
	public static final int _timestampOffset_;
	public static final int _totalMemorySizeOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_backoutOffset_ = 0;
		_causedRememberedSetOverflowOffset_ = 0;
		_currentThreadOffset_ = 0;
		_eventidOffset_ = 0;
		_failedFlipBytesOffset_ = 0;
		_failedFlipCountOffset_ = 0;
		_failedTenureBytesOffset_ = 0;
		_failedTenureCountOffset_ = 0;
		_flipBytesOffset_ = 0;
		_flipCountOffset_ = 0;
		_globalGCCountOffset_ = 0;
		_loaEnabledOffset_ = 0;
		_localGCCountOffset_ = 0;
		_nurseryFreeBytesOffset_ = 0;
		_nurseryTotalBytesOffset_ = 0;
		_rememberedSetOverflowedOffset_ = 0;
		_scanCacheOverflowOffset_ = 0;
		_subSpaceOffset_ = 0;
		_tenureAgeOffset_ = 0;
		_tenureBytesOffset_ = 0;
		_tenureCountOffset_ = 0;
		_tenureFreeBytesOffset_ = 0;
		_tenureLOAFreeBytesOffset_ = 0;
		_tenureLOATotalBytesOffset_ = 0;
		_tenureTotalBytesOffset_ = 0;
		_tiltedOffset_ = 0;
		_timestampOffset_ = 0;
		_totalMemorySizeOffset_ = 0;
	}

}
