/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_IncrementalGenerationalGC
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_IncrementalGenerationalGC {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __allocatedSinceLastPGCOffset_;
	public static final int __classLoaderRememberedSetOffset_;
	public static final int __collectionSetDelegateOffset_;
	public static final int __concurrentPhaseStatsOffset_;
	public static final int __configuredSubspaceOffset_;
	public static final int __copyForwardDelegateOffset_;
	public static final int __extensionsOffset_;
	public static final int __forceConcurrentTerminationOffset_;
	public static final int __globalCollectionStatisticsOffset_;
	public static final int __globalMarkDelegateOffset_;
	public static final int __globalMarkPhaseIncrementBytesStillToScanOffset_;
	public static final int __interRegionRememberedSetOffset_;
	public static final int __javaVMOffset_;
	public static final int __mainGCThreadOffset_;
	public static final int __markMapManagerOffset_;
	public static final int __partialCollectionStatisticsOffset_;
	public static final int __persistentGlobalMarkPhaseStateOffset_;
	public static final int __portLibraryOffset_;
	public static final int __projectedSurvivalCollectionSetDelegateOffset_;
	public static final int __reclaimDelegateOffset_;
	public static final int __regionManagerOffset_;
	public static final int __schedulingDelegateOffset_;
	public static final int __taxationThresholdOffset_;
	public static final int __workPacketsForGlobalGCOffset_;
	public static final int __workPacketsForPartialGCOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__allocatedSinceLastPGCOffset_ = 0;
		__classLoaderRememberedSetOffset_ = 0;
		__collectionSetDelegateOffset_ = 0;
		__concurrentPhaseStatsOffset_ = 0;
		__configuredSubspaceOffset_ = 0;
		__copyForwardDelegateOffset_ = 0;
		__extensionsOffset_ = 0;
		__forceConcurrentTerminationOffset_ = 0;
		__globalCollectionStatisticsOffset_ = 0;
		__globalMarkDelegateOffset_ = 0;
		__globalMarkPhaseIncrementBytesStillToScanOffset_ = 0;
		__interRegionRememberedSetOffset_ = 0;
		__javaVMOffset_ = 0;
		__mainGCThreadOffset_ = 0;
		__markMapManagerOffset_ = 0;
		__partialCollectionStatisticsOffset_ = 0;
		__persistentGlobalMarkPhaseStateOffset_ = 0;
		__portLibraryOffset_ = 0;
		__projectedSurvivalCollectionSetDelegateOffset_ = 0;
		__reclaimDelegateOffset_ = 0;
		__regionManagerOffset_ = 0;
		__schedulingDelegateOffset_ = 0;
		__taxationThresholdOffset_ = 0;
		__workPacketsForGlobalGCOffset_ = 0;
		__workPacketsForPartialGCOffset_ = 0;
	}

}
