/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_HeapResizeStats
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_HeapResizeStats {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __freeBytesAtSystemGCStartOffset_;
	public static final int __globalGCCountAtAFOffset_;
	public static final int __lastAFEndTimeOffset_;
	public static final int __lastActualHeapContractionSizeOffset_;
	public static final int __lastActualHeapExpansionSizeOffset_;
	public static final int __lastContractReasonOffset_;
	public static final int __lastContractTimeOffset_;
	public static final int __lastExpandReasonOffset_;
	public static final int __lastExpandTimeOffset_;
	public static final int __lastGCPercentageOffset_;
	public static final int __lastHeapContractionGCCountOffset_;
	public static final int __lastHeapExpansionGCCountOffset_;
	public static final int __lastLoaResizeReasonOffset_;
	public static final int __lastTimeOutsideGCOffset_;
	public static final int __thisAFStartTimeOffset_;
	public static final int __ticksInGCOffset_;
	public static final int __ticksOutsideGCOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__freeBytesAtSystemGCStartOffset_ = 0;
		__globalGCCountAtAFOffset_ = 0;
		__lastAFEndTimeOffset_ = 0;
		__lastActualHeapContractionSizeOffset_ = 0;
		__lastActualHeapExpansionSizeOffset_ = 0;
		__lastContractReasonOffset_ = 0;
		__lastContractTimeOffset_ = 0;
		__lastExpandReasonOffset_ = 0;
		__lastExpandTimeOffset_ = 0;
		__lastGCPercentageOffset_ = 0;
		__lastHeapContractionGCCountOffset_ = 0;
		__lastHeapExpansionGCCountOffset_ = 0;
		__lastLoaResizeReasonOffset_ = 0;
		__lastTimeOutsideGCOffset_ = 0;
		__thisAFStartTimeOffset_ = 0;
		__ticksInGCOffset_ = 0;
		__ticksOutsideGCOffset_ = 0;
	}

}
