/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_HeapMap
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_HeapMap {

	// VM Constants

	public static final long SIZEOF;
	public static final long BITS_IN_BYTE;
	public static final long J9MODRON_HEAPMAP_BIT_MASK;
	public static final long J9MODRON_HEAPMAP_BIT_SHIFT;
	public static final long J9MODRON_HEAPMAP_INDEX_SHIFT;
	public static final long J9MODRON_HEAPMAP_LOG_SIZEOF_UDATA;
	public static final long J9MODRON_HEAPMAP_SLOT_MASK;
	public static final long J9MODRON_HEAP_SLOTS_PER_HEAPMAP_BIT;
	public static final long J9MODRON_HEAP_SLOTS_PER_HEAPMAP_SLOT;

	// Offsets

	public static final int __extensionsOffset_;
	public static final int __heapBaseOffset_;
	public static final int __heapMapBaseDeltaOffset_;
	public static final int __heapMapBitMaskOffset_;
	public static final int __heapMapBitShiftOffset_;
	public static final int __heapMapBitsOffset_;
	public static final int __heapMapIndexShiftOffset_;
	public static final int __heapMapMemoryHandleOffset_;
	public static final int __heapTopOffset_;
	public static final int __maxHeapSizeOffset_;
	public static final int __useCompressedHeapMapOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		BITS_IN_BYTE = 0;
		J9MODRON_HEAPMAP_BIT_MASK = 0;
		J9MODRON_HEAPMAP_BIT_SHIFT = 0;
		J9MODRON_HEAPMAP_INDEX_SHIFT = 0;
		J9MODRON_HEAPMAP_LOG_SIZEOF_UDATA = 0;
		J9MODRON_HEAPMAP_SLOT_MASK = 0;
		J9MODRON_HEAP_SLOTS_PER_HEAPMAP_BIT = 0;
		J9MODRON_HEAP_SLOTS_PER_HEAPMAP_SLOT = 0;
		__extensionsOffset_ = 0;
		__heapBaseOffset_ = 0;
		__heapMapBaseDeltaOffset_ = 0;
		__heapMapBitMaskOffset_ = 0;
		__heapMapBitShiftOffset_ = 0;
		__heapMapBitsOffset_ = 0;
		__heapMapIndexShiftOffset_ = 0;
		__heapMapMemoryHandleOffset_ = 0;
		__heapTopOffset_ = 0;
		__maxHeapSizeOffset_ = 0;
		__useCompressedHeapMapOffset_ = 0;
	}

}
