/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_GCExtensions
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_GCExtensions {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __HeapManagementMXBeanBackCompatibilityEnabledOffset_;
	public static final int __TLHAsyncCallbackKeyOffset_;
	public static final int __asyncCallbackKeyOffset_;
	public static final int __stringTableListToTreeThresholdOffset_;
	public static final int _accessBarrierOffset_;
	public static final int _classLoaderManagerOffset_;
	public static final int _classUnloadingAnonymousClassWeightOffset_;
	public static final int _collectStringConstantsOffset_;
	public static final int _deadClassLoaderCacheSizeOffset_;
	public static final int _dynamicClassUnloadingOffset_;
	public static final int _dynamicClassUnloadingKickoffThresholdOffset_;
	public static final int _dynamicClassUnloadingKickoffThresholdForcedOffset_;
	public static final int _dynamicClassUnloadingSetOffset_;
	public static final int _dynamicClassUnloadingThresholdOffset_;
	public static final int _dynamicClassUnloadingThresholdForcedOffset_;
	public static final int _dynamicMaxSoftReferenceAgeOffset_;
	public static final int _finalizeCycleIntervalOffset_;
	public static final int _finalizeCycleLimitOffset_;
	public static final int _finalizeListManagerOffset_;
	public static final int _finalizeMainPriorityOffset_;
	public static final int _finalizeWorkerPriorityOffset_;
	public static final int _fvtest_forceFinalizeClassLoadersOffset_;
	public static final int _gcchkExtensionsOffset_;
	public static final int _hookInterfaceOffset_;
	public static final int _idleGCManagerOffset_;
	public static final int _initialRAMPercentOffset_;
	public static final int _markJavaStatsOffset_;
	public static final int _maxRAMPercentOffset_;
	public static final int _maxSoftReferenceAgeOffset_;
	public static final int _numaCommonThreadClassNamePatternsOffset_;
	public static final int _objectListFragmentCountOffset_;
	public static final int _ownableSynchronizerObjectListsOffset_;
	public static final int _referenceArrayCopyTableOffset_;
	public static final int _referenceObjectListsOffset_;
	public static final int _runtimeCheckDynamicClassUnloadingOffset_;
	public static final int _scavengerJavaStatsOffset_;
	public static final int _stringDedupPolicyOffset_;
	public static final int _stringTableOffset_;
	public static final int _tgcExtensionsOffset_;
	public static final int _unfinalizedObjectListsOffset_;
	public static final int _userSpecifiedParameters$_XmnOffset_;
	public static final int _userSpecifiedParameters$_XmnsOffset_;
	public static final int _userSpecifiedParameters$_XmnxOffset_;
	public static final int _verboseFunctionTableOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__HeapManagementMXBeanBackCompatibilityEnabledOffset_ = 0;
		__TLHAsyncCallbackKeyOffset_ = 0;
		__asyncCallbackKeyOffset_ = 0;
		__stringTableListToTreeThresholdOffset_ = 0;
		_accessBarrierOffset_ = 0;
		_classLoaderManagerOffset_ = 0;
		_classUnloadingAnonymousClassWeightOffset_ = 0;
		_collectStringConstantsOffset_ = 0;
		_deadClassLoaderCacheSizeOffset_ = 0;
		_dynamicClassUnloadingOffset_ = 0;
		_dynamicClassUnloadingKickoffThresholdOffset_ = 0;
		_dynamicClassUnloadingKickoffThresholdForcedOffset_ = 0;
		_dynamicClassUnloadingSetOffset_ = 0;
		_dynamicClassUnloadingThresholdOffset_ = 0;
		_dynamicClassUnloadingThresholdForcedOffset_ = 0;
		_dynamicMaxSoftReferenceAgeOffset_ = 0;
		_finalizeCycleIntervalOffset_ = 0;
		_finalizeCycleLimitOffset_ = 0;
		_finalizeListManagerOffset_ = 0;
		_finalizeMainPriorityOffset_ = 0;
		_finalizeWorkerPriorityOffset_ = 0;
		_fvtest_forceFinalizeClassLoadersOffset_ = 0;
		_gcchkExtensionsOffset_ = 0;
		_hookInterfaceOffset_ = 0;
		_idleGCManagerOffset_ = 0;
		_initialRAMPercentOffset_ = 0;
		_markJavaStatsOffset_ = 0;
		_maxRAMPercentOffset_ = 0;
		_maxSoftReferenceAgeOffset_ = 0;
		_numaCommonThreadClassNamePatternsOffset_ = 0;
		_objectListFragmentCountOffset_ = 0;
		_ownableSynchronizerObjectListsOffset_ = 0;
		_referenceArrayCopyTableOffset_ = 0;
		_referenceObjectListsOffset_ = 0;
		_runtimeCheckDynamicClassUnloadingOffset_ = 0;
		_scavengerJavaStatsOffset_ = 0;
		_stringDedupPolicyOffset_ = 0;
		_stringTableOffset_ = 0;
		_tgcExtensionsOffset_ = 0;
		_unfinalizedObjectListsOffset_ = 0;
		_userSpecifiedParameters$_XmnOffset_ = 0;
		_userSpecifiedParameters$_XmnsOffset_ = 0;
		_userSpecifiedParameters$_XmnxOffset_ = 0;
		_verboseFunctionTableOffset_ = 0;
	}

}
