/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_CopyForwardCompactGroup
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_CopyForwardCompactGroup {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __DFCopyAllocOffset_;
	public static final int __DFCopyBaseOffset_;
	public static final int __DFCopyTopOffset_;
	public static final int __allocationAgeOffset_;
	public static final int __copyCacheOffset_;
	public static final int __copyCacheLockOffset_;
	public static final int __discardedBytesOffset_;
	public static final int __edenStatsOffset_;
	public static final int __failedAllocateSizeOffset_;
	public static final int __failedCopiedBytesOffset_;
	public static final int __failedCopiedObjectsOffset_;
	public static final int __freeMemoryMeasuredOffset_;
	public static final int __markMapAtomicHeadSlotIndexOffset_;
	public static final int __markMapAtomicTailSlotIndexOffset_;
	public static final int __markMapGMPBitMaskOffset_;
	public static final int __markMapGMPSlotIndexOffset_;
	public static final int __markMapPGCBitMaskOffset_;
	public static final int __markMapPGCSlotIndexOffset_;
	public static final int __nonEdenStatsOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__DFCopyAllocOffset_ = 0;
		__DFCopyBaseOffset_ = 0;
		__DFCopyTopOffset_ = 0;
		__allocationAgeOffset_ = 0;
		__copyCacheOffset_ = 0;
		__copyCacheLockOffset_ = 0;
		__discardedBytesOffset_ = 0;
		__edenStatsOffset_ = 0;
		__failedAllocateSizeOffset_ = 0;
		__failedCopiedBytesOffset_ = 0;
		__failedCopiedObjectsOffset_ = 0;
		__freeMemoryMeasuredOffset_ = 0;
		__markMapAtomicHeadSlotIndexOffset_ = 0;
		__markMapAtomicTailSlotIndexOffset_ = 0;
		__markMapGMPBitMaskOffset_ = 0;
		__markMapGMPSlotIndexOffset_ = 0;
		__markMapPGCBitMaskOffset_ = 0;
		__markMapPGCSlotIndexOffset_ = 0;
		__nonEdenStatsOffset_ = 0;
	}

}
