/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: JniIDCache
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class JniIDCache {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _CLS_com_ibm_lang_management_MemoryUsageOffset_;
	public static final int _CLS_com_ibm_lang_management_ProcessorUsageOffset_;
	public static final int _CLS_com_ibm_oti_shared_SharedClassCacheInfoOffset_;
	public static final int _CLS_java_com_ibm_lang_management_JvmCpuMonitorInfoOffset_;
	public static final int _CLS_java_com_ibm_virtualization_management_GuestOSMemoryUsageOffset_;
	public static final int _CLS_java_com_ibm_virtualization_management_GuestOSProcessorUsageOffset_;
	public static final int _CLS_java_lang_AnonymousClassLoaderOffset_;
	public static final int _CLS_java_lang_StackTraceElementOffset_;
	public static final int _CLS_java_lang_StringOffset_;
	public static final int _CLS_java_lang_reflect_ParameterOffset_;
	public static final int _CLS_java_net_URLOffset_;
	public static final int _CLS_java_security_AccessControllerOffset_;
	public static final int _CLS_java_util_ArrayListOffset_;
	public static final int _CLS_openj9_management_internal_LockInfoBaseOffset_;
	public static final int _CLS_openj9_management_internal_MonitorInfoBaseOffset_;
	public static final int _CLS_openj9_management_internal_ThreadInfoBaseOffset_;
	public static final int _CLS_sun_reflect_ConstantPoolOffset_;
	public static final int _FID_java_lang_ClassLoader_vmRefOffset_;
	public static final int _FID_sun_reflect_ConstantPool_constantPoolOopOffset_;
	public static final int _MID_com_ibm_jvm_Stats_setFieldsOffset_;
	public static final int _MID_com_ibm_lang_management_GarbageCollectorMXBeanImpl_getNameOffset_;
	public static final int _MID_com_ibm_lang_management_MemoryUsage_updateValuesOffset_;
	public static final int _MID_com_ibm_lang_management_ProcessorUsage_initOffset_;
	public static final int _MID_com_ibm_lang_management_ProcessorUsage_updateValuesOffset_;
	public static final int _MID_com_ibm_lang_management_internal_ExtendedGarbageCollectorMXBeanImpl_buildGcInfoOffset_;
	public static final int _MID_com_ibm_oti_shared_SharedClassCacheInfo_initOffset_;
	public static final int _MID_java_com_ibm_lang_management_JvmCpuMonitorInfo_updateValuesOffset_;
	public static final int _MID_java_com_ibm_virtualization_management_GuestOSMemoryUsage_updateValuesOffset_;
	public static final int _MID_java_com_ibm_virtualization_management_GuestOSProcessorUsage_updateValuesOffset_;
	public static final int _MID_java_lang_AnonymousClassLoader_initOffset_;
	public static final int _MID_java_lang_ClassLoader_findLoadedClassOffset_;
	public static final int _MID_java_lang_Class_getNameOffset_;
	public static final int _MID_java_lang_StackTraceElement_isNativeMethodOffset_;
	public static final int _MID_java_lang_StackWalker_walkWrapperImplOffset_;
	public static final int _MID_java_lang_reflect_Parameter_initOffset_;
	public static final int _MID_java_net_URL_getPathOffset_;
	public static final int _MID_java_net_URL_getProtocolOffset_;
	public static final int _MID_java_security_AccessController_checkPermissionOffset_;
	public static final int _MID_java_util_ArrayList_addOffset_;
	public static final int _MID_openj9_management_internal_LockInfoBase_initOffset_;
	public static final int _MID_openj9_management_internal_MonitorInfoBase_initOffset_;
	public static final int _MID_openj9_management_internal_ThreadInfoBase_initOffset_;
	public static final int _MID_openj9_management_internal_ThreadInfoBase_init_nolocksOffset_;
	public static final int _traceGlobalsOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_CLS_com_ibm_lang_management_MemoryUsageOffset_ = 0;
		_CLS_com_ibm_lang_management_ProcessorUsageOffset_ = 0;
		_CLS_com_ibm_oti_shared_SharedClassCacheInfoOffset_ = 0;
		_CLS_java_com_ibm_lang_management_JvmCpuMonitorInfoOffset_ = 0;
		_CLS_java_com_ibm_virtualization_management_GuestOSMemoryUsageOffset_ = 0;
		_CLS_java_com_ibm_virtualization_management_GuestOSProcessorUsageOffset_ = 0;
		_CLS_java_lang_AnonymousClassLoaderOffset_ = 0;
		_CLS_java_lang_StackTraceElementOffset_ = 0;
		_CLS_java_lang_StringOffset_ = 0;
		_CLS_java_lang_reflect_ParameterOffset_ = 0;
		_CLS_java_net_URLOffset_ = 0;
		_CLS_java_security_AccessControllerOffset_ = 0;
		_CLS_java_util_ArrayListOffset_ = 0;
		_CLS_openj9_management_internal_LockInfoBaseOffset_ = 0;
		_CLS_openj9_management_internal_MonitorInfoBaseOffset_ = 0;
		_CLS_openj9_management_internal_ThreadInfoBaseOffset_ = 0;
		_CLS_sun_reflect_ConstantPoolOffset_ = 0;
		_FID_java_lang_ClassLoader_vmRefOffset_ = 0;
		_FID_sun_reflect_ConstantPool_constantPoolOopOffset_ = 0;
		_MID_com_ibm_jvm_Stats_setFieldsOffset_ = 0;
		_MID_com_ibm_lang_management_GarbageCollectorMXBeanImpl_getNameOffset_ = 0;
		_MID_com_ibm_lang_management_MemoryUsage_updateValuesOffset_ = 0;
		_MID_com_ibm_lang_management_ProcessorUsage_initOffset_ = 0;
		_MID_com_ibm_lang_management_ProcessorUsage_updateValuesOffset_ = 0;
		_MID_com_ibm_lang_management_internal_ExtendedGarbageCollectorMXBeanImpl_buildGcInfoOffset_ = 0;
		_MID_com_ibm_oti_shared_SharedClassCacheInfo_initOffset_ = 0;
		_MID_java_com_ibm_lang_management_JvmCpuMonitorInfo_updateValuesOffset_ = 0;
		_MID_java_com_ibm_virtualization_management_GuestOSMemoryUsage_updateValuesOffset_ = 0;
		_MID_java_com_ibm_virtualization_management_GuestOSProcessorUsage_updateValuesOffset_ = 0;
		_MID_java_lang_AnonymousClassLoader_initOffset_ = 0;
		_MID_java_lang_ClassLoader_findLoadedClassOffset_ = 0;
		_MID_java_lang_Class_getNameOffset_ = 0;
		_MID_java_lang_StackTraceElement_isNativeMethodOffset_ = 0;
		_MID_java_lang_StackWalker_walkWrapperImplOffset_ = 0;
		_MID_java_lang_reflect_Parameter_initOffset_ = 0;
		_MID_java_net_URL_getPathOffset_ = 0;
		_MID_java_net_URL_getProtocolOffset_ = 0;
		_MID_java_security_AccessController_checkPermissionOffset_ = 0;
		_MID_java_util_ArrayList_addOffset_ = 0;
		_MID_openj9_management_internal_LockInfoBase_initOffset_ = 0;
		_MID_openj9_management_internal_MonitorInfoBase_initOffset_ = 0;
		_MID_openj9_management_internal_ThreadInfoBase_initOffset_ = 0;
		_MID_openj9_management_internal_ThreadInfoBase_init_nolocksOffset_ = 0;
		_traceGlobalsOffset_ = 0;
	}

}
