/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9VmconstantpoolConstants
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9VmconstantpoolConstants {

	// VM Constants

	public static final long SIZEOF;
	public static final long J9VMCONSTANTPOOL_COMIBMOTILANGTHREADDEATH;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIUTILWEAKREFERENCENODE;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIUTILWEAKREFERENCENODE_NEXT;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMREFLECTOBJECTINVALIDEXCEPTION;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_ADDRESS_SIZE;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_FJ9OBJECT_SIZE;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_GLR_CANCEL_ABSOLUTE_THRESHOLD;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_GLR_ENABLE_GLOBAL_LOCK_RESERVATION;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_GLR_MINIMUM_LEARNING_RATIO;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_GLR_MINIMUM_RESERVED_RATIO;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_GLR_RESERVED_ABSOLUTE_THRESHOLD;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_IS_BIG_ENDIAN;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_CLASS_DEPTH_AND_FLAGS_OFFSET;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_INITIALIZE_STATUS_OFFSET;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_INIT_SUCCEEDED;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_INSTANCESIZE_OFFSET;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_INSTANCE_DESCRIPTION_OFFSET;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_LOCK_OFFSET_OFFSET;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_LOCK_RESERVATION_HISTORY_CANCEL_COUNTER_OFFSET;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_LOCK_RESERVATION_HISTORY_RESERVED_COUNTER_OFFSET;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_RESERVABLE_LOCK_WORD_INIT;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_ROMCLASS_OFFSET;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_SIZE;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_SUPERCLASSES_OFFSET;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9ROMCLASS_MODIFIERS_OFFSET;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_ACC_CLASS_ARRAY;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_ACC_CLASS_INTERNAL_PRIMITIVE_TYPE;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_CLASSLOADER_TYPE_BOOT;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_CLASSLOADER_TYPE_OTHERS;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_CLASSLOADER_TYPE_PLATFORM;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_ALLOCATION_TYPE;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_ALLOCATION_TYPE_SEGREGATED;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_ALLOCATION_TYPE_TLH;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_POLICY;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_POLICY_BALANCED;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_POLICY_GENCON;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_POLICY_METRONOME;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_POLICY_NOGC;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_POLICY_OPTAVGPAUSE;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_POLICY_OPTTHRUPUT;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE_ALWAYS;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE_CARDMARK;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE_CARDMARK_AND_OLDCHECK;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE_CARDMARK_INCREMENTAL;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE_NONE;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE_OLDCHECK;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE_REALTIME;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_JAVA_CLASS_DEPTH_MASK;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_JAVA_CLASS_MASK;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_JAVA_CLASS_RAM_SHAPE_SHIFT;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_JIT_STRING_DEDUP_POLICY;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_STRING_COMPRESSION_ENABLED;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_OBJECT_HEADER_HAS_BEEN_MOVED_IN_CLASS;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_OBJECT_HEADER_LOCK_LEARNING;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_OBJECT_HEADER_LOCK_RESERVED;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_OBJECT_HEADER_SHAPE_MASK;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_OBJECT_HEADER_SIZE;
	public static final long J9VMCONSTANTPOOL_JAVAIOUTFDATAFORMATEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGABSTRACTMETHODERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGARITHMETICEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGARRAYINDEXOUTOFBOUNDSEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGARRAYSTOREEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGBOOLEAN;
	public static final long J9VMCONSTANTPOOL_JAVALANGBOOLEAN_VALUE;
	public static final long J9VMCONSTANTPOOL_JAVALANGBYTE;
	public static final long J9VMCONSTANTPOOL_JAVALANGBYTE_VALUE;
	public static final long J9VMCONSTANTPOOL_JAVALANGCHARACTER;
	public static final long J9VMCONSTANTPOOL_JAVALANGCHARACTER_VALUE;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASS;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASSCASTEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASSCIRCULARITYERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASSFORMATERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASSLOADER;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASSLOADER_CLASSLOADERNAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASSLOADER_ISPARALLELCAPABLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASSLOADER_LOADCLASS;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASSLOADER_PARENT;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASSLOADER_UNNAMEDMODULE;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASSLOADER_VMREF;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASSNOTFOUNDEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASS_ANNOTATIONCACHE;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASS_CLASSDATA;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASS_CLASSLOADER;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASS_CLASSNAMESTRING;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASS_FILENAMESTRING;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASS_INITIALIZATIONLOCK;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASS_METHODHANDLECACHE;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASS_MODULE;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASS_PROTECTIONDOMAIN;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASS_REFLECTCACHE;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASS_VMREF;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLONENOTSUPPORTEDEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGDOUBLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGDOUBLE_VALUE;
	public static final long J9VMCONSTANTPOOL_JAVALANGEXCEPTIONININITIALIZERERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGEXCEPTIONININITIALIZERERROR_EXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGFLOAT;
	public static final long J9VMCONSTANTPOOL_JAVALANGFLOAT_VALUE;
	public static final long J9VMCONSTANTPOOL_JAVALANGILLEGALACCESSERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGILLEGALACCESSEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGILLEGALARGUMENTEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGILLEGALMONITORSTATEEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGILLEGALTHREADSTATEEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGINCOMPATIBLECLASSCHANGEERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGINDEXOUTOFBOUNDSEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGINSTANTIATIONERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGINSTANTIATIONEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGINTEGER;
	public static final long J9VMCONSTANTPOOL_JAVALANGINTEGER_VALUE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINTERNALERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGINTERNALRAMCLASS;
	public static final long J9VMCONSTANTPOOL_JAVALANGINTERNALRAMCLASS_VMREF;
	public static final long J9VMCONSTANTPOOL_JAVALANGINTERRUPTEDEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKECOLLECTHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKECOLLECTHANDLE_COLLECTARRAYSIZE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKECOLLECTHANDLE_COLLECTPOSITION;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKECOLLECTHANDLE_NEXT;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKECONSTANTDOUBLEHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKECONSTANTDOUBLEHANDLE_VALUE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKECONSTANTFLOATHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKECONSTANTFLOATHANDLE_VALUE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKECONSTANTINTHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKECONSTANTINTHANDLE_VALUE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKECONSTANTLONGHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKECONSTANTLONGHANDLE_VALUE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKECONSTANTOBJECTHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKECONSTANTOBJECTHANDLE_VALUE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKECONVERTHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKECONVERTHANDLE_NEXT;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKECONVERTHANDLE_REQUIRESBOXING;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEDEFAULTMETHODCONFLICTEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEDYNAMICINVOKERHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEDYNAMICINVOKERHANDLE_SITE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEFIELDVARHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEFIELDVARHANDLE_DEFININGCLASS;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEFILTERARGUMENTSHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEFILTERARGUMENTSHANDLE_FILTERS;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEFILTERARGUMENTSHANDLE_NEXT;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEFILTERARGUMENTSHANDLE_STARTPOS;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEFILTERARGUMENTSWITHCOMBINERHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEFILTERARGUMENTSWITHCOMBINERHANDLE_ARGUMENTINDICES;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEFILTERARGUMENTSWITHCOMBINERHANDLE_COMBINER;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEFILTERARGUMENTSWITHCOMBINERHANDLE_FILTERPOSITION;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEFILTERARGUMENTSWITHCOMBINERHANDLE_NEXT;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEFILTERRETURNHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEFILTERRETURNHANDLE_FILTER;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEFOLDHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEFOLDHANDLE_ARGUMENTINDICES;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEFOLDHANDLE_COMBINER;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEFOLDHANDLE_FOLDPOSITION;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEFOLDHANDLE_NEXT;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEGUARDWITHTESTHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEGUARDWITHTESTHANDLE_FALSETARGET;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEGUARDWITHTESTHANDLE_GUARD;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEGUARDWITHTESTHANDLE_TRUETARGET;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEINSERTHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEINSERTHANDLE_INSERTIONINDEX;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEINSERTHANDLE_NEXT;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEINSERTHANDLE_VALUES;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEINVOKEEXACTHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEINVOKEEXACTHANDLE_NEXTTYPE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEINVOKEGENERICHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEINVOKEGENERICHANDLE_CASTTYPE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKELAMBDAFORM;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKELAMBDAFORM_VMENTRY;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMEMBERNAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMEMBERNAME_CLAZZ;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMEMBERNAME_FLAGS;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMEMBERNAME_NAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMEMBERNAME_RESOLUTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMEMBERNAME_TYPE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLECACHE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLECACHE_DIRECTHANDLESHEAD;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLERESOLVER;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLERESOLVER_CONSTRUCTORPLACEHOLDER;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLERESOLVER_LINKCALLERMETHOD;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLERESOLVER_RESOLVECONSTANTDYNAMIC;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLERESOLVER_RESOLVEINVOKEDYNAMIC;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLERESOLVER_SENDRESOLVEMETHODHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE_FILTERARGUMENTSPLACEHOLDER;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE_FILTERARGUMENTSWITHCOMBINERPLACEHOLDER;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE_FOLDHANDLEPLACEHOLDER;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE_FORGENERICINVOKE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE_FORM;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE_GUARDWITHTESTPLACEHOLDER;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE_INVOCATIONCOUNT;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE_KIND;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE_PREVIOUSASTYPE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE_RETURNFILTERPLACEHOLDER;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE_THUNKS;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE_TYPE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODTYPE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODTYPEFORM;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODTYPEHELPER;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODTYPEHELPER_VMRESOLVEFROMMETHODDESCRIPTORSTRING;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODTYPE_ARGSLOTS;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODTYPE_METHODDESCRIPTOR;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODTYPE_PTYPES;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODTYPE_RTYPE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODTYPE_STACKDESCRIPTIONBITS;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMUTABLECALLSITE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMUTABLECALLSITE_TARGET;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKENATIVEMETHODHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKENATIVEMETHODHANDLE_J9NATIVECALLOUTDATAREF;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEPASSTHROUGHHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEPASSTHROUGHHANDLE_EQUIVALENT;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEPERMUTEHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEPERMUTEHANDLE_NEXT;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEPERMUTEHANDLE_PERMUTE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEPRIMITIVEHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEPRIMITIVEHANDLE_DEFC;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEPRIMITIVEHANDLE_RAWMODIFIERS;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEPRIMITIVEHANDLE_REFERENCECLASS;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEPRIMITIVEHANDLE_VMSLOT;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKERECEIVERBOUNDHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKERECEIVERBOUNDHANDLE_RECEIVER;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKESPREADHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKESPREADHANDLE_ARRAYCLASS;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKESPREADHANDLE_NEXT;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKESPREADHANDLE_SPREADCOUNT;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKESPREADHANDLE_SPREADPOSITION;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKETHUNKTUPLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKETHUNKTUPLE_I2JINVOKEEXACTTHUNK;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKETHUNKTUPLE_INVOCATIONCOUNT;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEVARARGSCOLLECTORHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEVARARGSCOLLECTORHANDLE_NEXT;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEVARHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEVARHANDLEINVOKEHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEVARHANDLEINVOKEHANDLE_ACCESSMODETYPE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEVARHANDLEINVOKEHANDLE_OPERATION;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEVARHANDLE_HANDLETABLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEVARHANDLE_MODIFIERS;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEVOLATILECALLSITE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEVOLATILECALLSITE_TARGET;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEWRONGMETHODTYPEEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS;
	public static final long J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALSCLASSINITIALIZATIONLOCK;
	public static final long J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALSCLASSINITIALIZATIONLOCK_THECLASS;
	public static final long J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS_CHECKPACKAGEACCESS;
	public static final long J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS_COMPLETEINITIALIZATION;
	public static final long J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS_FORMATNOSUCHMETHOD;
	public static final long J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS_INITIALIZATIONALREADYFAILED;
	public static final long J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS_NEWINSTANCEIMPL;
	public static final long J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS_RECORDINITIALIZATIONFAILURE;
	public static final long J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS_THREADCLEANUP;
	public static final long J9VMCONSTANTPOOL_JAVALANGLAYERINSTANTIATIONEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGLINKAGEERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGLONG;
	public static final long J9VMCONSTANTPOOL_JAVALANGLONG_VALUE;
	public static final long J9VMCONSTANTPOOL_JAVALANGMODULE;
	public static final long J9VMCONSTANTPOOL_JAVALANGMODULE_LOADER;
	public static final long J9VMCONSTANTPOOL_JAVALANGMODULE_NAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGNEGATIVEARRAYSIZEEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGNOCLASSDEFFOUNDERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGNOSUCHFIELDERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGNOSUCHFIELDEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGNOSUCHMETHODERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGNOSUCHMETHODEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGNULLPOINTEREXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGOBJECT;
	public static final long J9VMCONSTANTPOOL_JAVALANGOUTOFMEMORYERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR_ANNOTATIONS;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR_DECLARINGCLASS;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR_EXCEPTIONTYPES;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR_INTMETHODID;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR_MODIFIERS;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR_PARAMETERANNOTATIONS;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR_PARAMETERTYPES;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR_SIGNATURE;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD_ANNOTATIONS;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD_DECLARINGCLASS;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD_INTFIELDID;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD_MODIFIERS;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD_NAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD_SIGNATURE;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD_TRUSTEDFINAL;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD_TYPE;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTINVOCATIONTARGETEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_ANNOTATIONDEFAULT;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_ANNOTATIONS;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_DECLARINGCLASS;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_EXCEPTIONTYPES;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_INTMETHODID;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_MODIFIERS;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_NAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_PARAMETERANNOTATIONS;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_PARAMETERTYPES;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_RETURNTYPE;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_SIGNATURE;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTRECORDCOMPONENT;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTRECORDCOMPONENT_ACCESSOR;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTRECORDCOMPONENT_ANNOTATIONS;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTRECORDCOMPONENT_CLAZZ;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTRECORDCOMPONENT_NAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTRECORDCOMPONENT_SIGNATURE;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTRECORDCOMPONENT_TYPE;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTRECORDCOMPONENT_TYPEANNOTATIONS;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFREFERENCE;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFREFERENCE_QUEUE;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFREFERENCE_REFERENT;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFREFERENCE_STATE;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFSOFTREFERENCE;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFSOFTREFERENCE_AGE;
	public static final long J9VMCONSTANTPOOL_JAVALANGSECURITYEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGSHORT;
	public static final long J9VMCONSTANTPOOL_JAVALANGSHORT_VALUE;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKOVERFLOWERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_CLASSLOADERNAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_DECLARINGCLASS;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_FILENAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_INCLUDECLASSLOADERNAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_INCLUDEMODULEVERSION;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_LINENUMBER;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_METHODNAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_MODULENAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_MODULEVERSION;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_SOURCE;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_BYTECODEINDEX;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_CALLERSENSITIVE;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_CLASSLOADERNAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_CLASSNAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_DECLARINGCLASS;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_FILENAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_FRAMEMODULE;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_LINENUMBER;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_METHODNAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_METHODSIGNATURE;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTRING;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTRINGINDEXOUTOFBOUNDSEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTRINGSTRINGCOMPRESSIONFLAG;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTRING_CODER;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTRING_COMPRESSIONFLAG;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTRING_COUNT;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTRING_HASHCODE;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTRING_VALUE;
	public static final long J9VMCONSTANTPOOL_JAVALANGSYSTEM;
	public static final long J9VMCONSTANTPOOL_JAVALANGSYSTEM_SECURITY;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREAD;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREADDEATH;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREADGROUP;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREADGROUP_CHILDRENGROUPS;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREADGROUP_CHILDRENGROUPSLOCK;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREADGROUP_CHILDRENTHREADS;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREADGROUP_CHILDRENTHREADSLOCK;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREADGROUP_ISDAEMON;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREADGROUP_MAXPRIORITY;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREADGROUP_NAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREADGROUP_NUMGROUPS;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREADGROUP_NUMTHREADS;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREADGROUP_PARENT;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREAD_CONTEXTCLASSLOADER;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREAD_DEADINTERRUPT;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREAD_GROUP;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREAD_INHERITEDACCESSCONTROLCONTEXT;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREAD_INIT;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREAD_ISDAEMON;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREAD_LOCK;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREAD_NAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREAD_PARKBLOCKER;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREAD_PRIORITY;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREAD_RUNNABLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREAD_STACKSIZE;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREAD_STARTED;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREAD_STOPCALLED;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREAD_THREADREF;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREAD_TID;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREAD_UNCAUGHTEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHROWABLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHROWABLE_CAUSE;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHROWABLE_DETAILMESSAGE;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHROWABLE_DISABLEWRITABLESTACKTRACE;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHROWABLE_STACKTRACE;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHROWABLE_WALKBACK;
	public static final long J9VMCONSTANTPOOL_JAVALANGUNSATISFIEDLINKERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGUNSUPPORTEDCLASSVERSIONERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGVERIFYERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGVIRTUALMACHINEERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGVOID;
	public static final long J9VMCONSTANTPOOL_JAVAUTILCONCURRENTLOCKSABSTRACTOWNABLESYNCHRONIZER;
	public static final long J9VMCONSTANTPOOL_JAVAUTILCONCURRENTLOCKSABSTRACTOWNABLESYNCHRONIZER_EXCLUSIVEOWNERTHREAD;
	public static final long J9VMCONSTANTPOOL_JDKINTERNALLOADERNATIVELIBRARIES;
	public static final long J9VMCONSTANTPOOL_JDKINTERNALLOADERNATIVELIBRARIESNATIVELIBRARYIMPL;
	public static final long J9VMCONSTANTPOOL_JDKINTERNALLOADERNATIVELIBRARIESNATIVELIBRARYIMPL_FROMCLASS;
	public static final long J9VMCONSTANTPOOL_JDKINTERNALLOADERNATIVELIBRARIES_LOAD;
	public static final long J9VM_VMCONSTANTPOOL_SIZE;
	public static final long JCL_RTFLAG_DEFAULT;
	public static final long JCL_RTFLAG_INTERP_HOT_CODE_REPLACEMENT;
	public static final long JCL_RTFLAG_JIT_NEW_INSTANCE_PROTOTYPE;
	public static final long JCL_RTFLAG_OPT_METHOD_HANDLE;
	public static final long JCL_RTFLAG_OPT_METHOD_HANDLE_COMMON;
	public static final long JCL_RTFLAG_OPT_MODULE;
	public static final long JCL_RTFLAG_OPT_OPENJDK_METHODHANDLE;
	public static final long JCL_RTFLAG_OPT_PANAMA;
	public static final long JCL_RTFLAG_OPT_REFLECT;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		J9VMCONSTANTPOOL_COMIBMOTILANGTHREADDEATH = 0;
		J9VMCONSTANTPOOL_COMIBMOTIUTILWEAKREFERENCENODE = 0;
		J9VMCONSTANTPOOL_COMIBMOTIUTILWEAKREFERENCENODE_NEXT = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMREFLECTOBJECTINVALIDEXCEPTION = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_ADDRESS_SIZE = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_FJ9OBJECT_SIZE = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_GLR_CANCEL_ABSOLUTE_THRESHOLD = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_GLR_ENABLE_GLOBAL_LOCK_RESERVATION = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_GLR_MINIMUM_LEARNING_RATIO = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_GLR_MINIMUM_RESERVED_RATIO = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_GLR_RESERVED_ABSOLUTE_THRESHOLD = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_IS_BIG_ENDIAN = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_CLASS_DEPTH_AND_FLAGS_OFFSET = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_INITIALIZE_STATUS_OFFSET = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_INIT_SUCCEEDED = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_INSTANCESIZE_OFFSET = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_INSTANCE_DESCRIPTION_OFFSET = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_LOCK_OFFSET_OFFSET = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_LOCK_RESERVATION_HISTORY_CANCEL_COUNTER_OFFSET = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_LOCK_RESERVATION_HISTORY_RESERVED_COUNTER_OFFSET = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_RESERVABLE_LOCK_WORD_INIT = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_ROMCLASS_OFFSET = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_SIZE = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_SUPERCLASSES_OFFSET = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9ROMCLASS_MODIFIERS_OFFSET = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_ACC_CLASS_ARRAY = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_ACC_CLASS_INTERNAL_PRIMITIVE_TYPE = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_CLASSLOADER_TYPE_BOOT = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_CLASSLOADER_TYPE_OTHERS = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_CLASSLOADER_TYPE_PLATFORM = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_ALLOCATION_TYPE = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_ALLOCATION_TYPE_SEGREGATED = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_ALLOCATION_TYPE_TLH = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_POLICY = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_POLICY_BALANCED = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_POLICY_GENCON = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_POLICY_METRONOME = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_POLICY_NOGC = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_POLICY_OPTAVGPAUSE = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_POLICY_OPTTHRUPUT = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE_ALWAYS = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE_CARDMARK = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE_CARDMARK_AND_OLDCHECK = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE_CARDMARK_INCREMENTAL = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE_NONE = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE_OLDCHECK = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE_REALTIME = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_JAVA_CLASS_DEPTH_MASK = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_JAVA_CLASS_MASK = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_JAVA_CLASS_RAM_SHAPE_SHIFT = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_JIT_STRING_DEDUP_POLICY = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_STRING_COMPRESSION_ENABLED = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_OBJECT_HEADER_HAS_BEEN_MOVED_IN_CLASS = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_OBJECT_HEADER_LOCK_LEARNING = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_OBJECT_HEADER_LOCK_RESERVED = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_OBJECT_HEADER_SHAPE_MASK = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_OBJECT_HEADER_SIZE = 0;
		J9VMCONSTANTPOOL_JAVAIOUTFDATAFORMATEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGABSTRACTMETHODERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGARITHMETICEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGARRAYINDEXOUTOFBOUNDSEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGARRAYSTOREEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGBOOLEAN = 0;
		J9VMCONSTANTPOOL_JAVALANGBOOLEAN_VALUE = 0;
		J9VMCONSTANTPOOL_JAVALANGBYTE = 0;
		J9VMCONSTANTPOOL_JAVALANGBYTE_VALUE = 0;
		J9VMCONSTANTPOOL_JAVALANGCHARACTER = 0;
		J9VMCONSTANTPOOL_JAVALANGCHARACTER_VALUE = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASS = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASSCASTEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASSCIRCULARITYERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASSFORMATERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASSLOADER = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASSLOADER_CLASSLOADERNAME = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASSLOADER_ISPARALLELCAPABLE = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASSLOADER_LOADCLASS = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASSLOADER_PARENT = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASSLOADER_UNNAMEDMODULE = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASSLOADER_VMREF = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASSNOTFOUNDEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASS_ANNOTATIONCACHE = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASS_CLASSDATA = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASS_CLASSLOADER = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASS_CLASSNAMESTRING = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASS_FILENAMESTRING = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASS_INITIALIZATIONLOCK = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASS_METHODHANDLECACHE = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASS_MODULE = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASS_PROTECTIONDOMAIN = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASS_REFLECTCACHE = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASS_VMREF = 0;
		J9VMCONSTANTPOOL_JAVALANGCLONENOTSUPPORTEDEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGDOUBLE = 0;
		J9VMCONSTANTPOOL_JAVALANGDOUBLE_VALUE = 0;
		J9VMCONSTANTPOOL_JAVALANGEXCEPTIONININITIALIZERERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGEXCEPTIONININITIALIZERERROR_EXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGFLOAT = 0;
		J9VMCONSTANTPOOL_JAVALANGFLOAT_VALUE = 0;
		J9VMCONSTANTPOOL_JAVALANGILLEGALACCESSERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGILLEGALACCESSEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGILLEGALARGUMENTEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGILLEGALMONITORSTATEEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGILLEGALTHREADSTATEEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGINCOMPATIBLECLASSCHANGEERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGINDEXOUTOFBOUNDSEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGINSTANTIATIONERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGINSTANTIATIONEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGINTEGER = 0;
		J9VMCONSTANTPOOL_JAVALANGINTEGER_VALUE = 0;
		J9VMCONSTANTPOOL_JAVALANGINTERNALERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGINTERNALRAMCLASS = 0;
		J9VMCONSTANTPOOL_JAVALANGINTERNALRAMCLASS_VMREF = 0;
		J9VMCONSTANTPOOL_JAVALANGINTERRUPTEDEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKECOLLECTHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKECOLLECTHANDLE_COLLECTARRAYSIZE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKECOLLECTHANDLE_COLLECTPOSITION = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKECOLLECTHANDLE_NEXT = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKECONSTANTDOUBLEHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKECONSTANTDOUBLEHANDLE_VALUE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKECONSTANTFLOATHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKECONSTANTFLOATHANDLE_VALUE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKECONSTANTINTHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKECONSTANTINTHANDLE_VALUE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKECONSTANTLONGHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKECONSTANTLONGHANDLE_VALUE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKECONSTANTOBJECTHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKECONSTANTOBJECTHANDLE_VALUE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKECONVERTHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKECONVERTHANDLE_NEXT = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKECONVERTHANDLE_REQUIRESBOXING = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEDEFAULTMETHODCONFLICTEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEDYNAMICINVOKERHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEDYNAMICINVOKERHANDLE_SITE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEFIELDVARHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEFIELDVARHANDLE_DEFININGCLASS = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEFILTERARGUMENTSHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEFILTERARGUMENTSHANDLE_FILTERS = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEFILTERARGUMENTSHANDLE_NEXT = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEFILTERARGUMENTSHANDLE_STARTPOS = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEFILTERARGUMENTSWITHCOMBINERHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEFILTERARGUMENTSWITHCOMBINERHANDLE_ARGUMENTINDICES = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEFILTERARGUMENTSWITHCOMBINERHANDLE_COMBINER = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEFILTERARGUMENTSWITHCOMBINERHANDLE_FILTERPOSITION = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEFILTERARGUMENTSWITHCOMBINERHANDLE_NEXT = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEFILTERRETURNHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEFILTERRETURNHANDLE_FILTER = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEFOLDHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEFOLDHANDLE_ARGUMENTINDICES = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEFOLDHANDLE_COMBINER = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEFOLDHANDLE_FOLDPOSITION = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEFOLDHANDLE_NEXT = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEGUARDWITHTESTHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEGUARDWITHTESTHANDLE_FALSETARGET = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEGUARDWITHTESTHANDLE_GUARD = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEGUARDWITHTESTHANDLE_TRUETARGET = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEINSERTHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEINSERTHANDLE_INSERTIONINDEX = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEINSERTHANDLE_NEXT = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEINSERTHANDLE_VALUES = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEINVOKEEXACTHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEINVOKEEXACTHANDLE_NEXTTYPE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEINVOKEGENERICHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEINVOKEGENERICHANDLE_CASTTYPE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKELAMBDAFORM = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKELAMBDAFORM_VMENTRY = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMEMBERNAME = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMEMBERNAME_CLAZZ = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMEMBERNAME_FLAGS = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMEMBERNAME_NAME = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMEMBERNAME_RESOLUTION = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMEMBERNAME_TYPE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLECACHE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLECACHE_DIRECTHANDLESHEAD = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLERESOLVER = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLERESOLVER_CONSTRUCTORPLACEHOLDER = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLERESOLVER_LINKCALLERMETHOD = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLERESOLVER_RESOLVECONSTANTDYNAMIC = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLERESOLVER_RESOLVEINVOKEDYNAMIC = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLERESOLVER_SENDRESOLVEMETHODHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE_FILTERARGUMENTSPLACEHOLDER = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE_FILTERARGUMENTSWITHCOMBINERPLACEHOLDER = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE_FOLDHANDLEPLACEHOLDER = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE_FORGENERICINVOKE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE_FORM = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE_GUARDWITHTESTPLACEHOLDER = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE_INVOCATIONCOUNT = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE_KIND = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE_PREVIOUSASTYPE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE_RETURNFILTERPLACEHOLDER = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE_THUNKS = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE_TYPE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODTYPE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODTYPEFORM = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODTYPEHELPER = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODTYPEHELPER_VMRESOLVEFROMMETHODDESCRIPTORSTRING = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODTYPE_ARGSLOTS = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODTYPE_METHODDESCRIPTOR = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODTYPE_PTYPES = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODTYPE_RTYPE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODTYPE_STACKDESCRIPTIONBITS = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMUTABLECALLSITE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMUTABLECALLSITE_TARGET = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKENATIVEMETHODHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKENATIVEMETHODHANDLE_J9NATIVECALLOUTDATAREF = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEPASSTHROUGHHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEPASSTHROUGHHANDLE_EQUIVALENT = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEPERMUTEHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEPERMUTEHANDLE_NEXT = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEPERMUTEHANDLE_PERMUTE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEPRIMITIVEHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEPRIMITIVEHANDLE_DEFC = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEPRIMITIVEHANDLE_RAWMODIFIERS = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEPRIMITIVEHANDLE_REFERENCECLASS = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEPRIMITIVEHANDLE_VMSLOT = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKERECEIVERBOUNDHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKERECEIVERBOUNDHANDLE_RECEIVER = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKESPREADHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKESPREADHANDLE_ARRAYCLASS = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKESPREADHANDLE_NEXT = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKESPREADHANDLE_SPREADCOUNT = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKESPREADHANDLE_SPREADPOSITION = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKETHUNKTUPLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKETHUNKTUPLE_I2JINVOKEEXACTTHUNK = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKETHUNKTUPLE_INVOCATIONCOUNT = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEVARARGSCOLLECTORHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEVARARGSCOLLECTORHANDLE_NEXT = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEVARHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEVARHANDLEINVOKEHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEVARHANDLEINVOKEHANDLE_ACCESSMODETYPE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEVARHANDLEINVOKEHANDLE_OPERATION = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEVARHANDLE_HANDLETABLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEVARHANDLE_MODIFIERS = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEVOLATILECALLSITE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEVOLATILECALLSITE_TARGET = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEWRONGMETHODTYPEEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS = 0;
		J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALSCLASSINITIALIZATIONLOCK = 0;
		J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALSCLASSINITIALIZATIONLOCK_THECLASS = 0;
		J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS_CHECKPACKAGEACCESS = 0;
		J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS_COMPLETEINITIALIZATION = 0;
		J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS_FORMATNOSUCHMETHOD = 0;
		J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS_INITIALIZATIONALREADYFAILED = 0;
		J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS_NEWINSTANCEIMPL = 0;
		J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS_RECORDINITIALIZATIONFAILURE = 0;
		J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS_THREADCLEANUP = 0;
		J9VMCONSTANTPOOL_JAVALANGLAYERINSTANTIATIONEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGLINKAGEERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGLONG = 0;
		J9VMCONSTANTPOOL_JAVALANGLONG_VALUE = 0;
		J9VMCONSTANTPOOL_JAVALANGMODULE = 0;
		J9VMCONSTANTPOOL_JAVALANGMODULE_LOADER = 0;
		J9VMCONSTANTPOOL_JAVALANGMODULE_NAME = 0;
		J9VMCONSTANTPOOL_JAVALANGNEGATIVEARRAYSIZEEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGNOCLASSDEFFOUNDERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGNOSUCHFIELDERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGNOSUCHFIELDEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGNOSUCHMETHODERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGNOSUCHMETHODEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGNULLPOINTEREXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGOBJECT = 0;
		J9VMCONSTANTPOOL_JAVALANGOUTOFMEMORYERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR_ANNOTATIONS = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR_DECLARINGCLASS = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR_EXCEPTIONTYPES = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR_INTMETHODID = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR_MODIFIERS = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR_PARAMETERANNOTATIONS = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR_PARAMETERTYPES = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR_SIGNATURE = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD_ANNOTATIONS = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD_DECLARINGCLASS = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD_INTFIELDID = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD_MODIFIERS = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD_NAME = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD_SIGNATURE = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD_TRUSTEDFINAL = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD_TYPE = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTINVOCATIONTARGETEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_ANNOTATIONDEFAULT = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_ANNOTATIONS = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_DECLARINGCLASS = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_EXCEPTIONTYPES = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_INTMETHODID = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_MODIFIERS = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_NAME = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_PARAMETERANNOTATIONS = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_PARAMETERTYPES = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_RETURNTYPE = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_SIGNATURE = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTRECORDCOMPONENT = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTRECORDCOMPONENT_ACCESSOR = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTRECORDCOMPONENT_ANNOTATIONS = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTRECORDCOMPONENT_CLAZZ = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTRECORDCOMPONENT_NAME = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTRECORDCOMPONENT_SIGNATURE = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTRECORDCOMPONENT_TYPE = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTRECORDCOMPONENT_TYPEANNOTATIONS = 0;
		J9VMCONSTANTPOOL_JAVALANGREFREFERENCE = 0;
		J9VMCONSTANTPOOL_JAVALANGREFREFERENCE_QUEUE = 0;
		J9VMCONSTANTPOOL_JAVALANGREFREFERENCE_REFERENT = 0;
		J9VMCONSTANTPOOL_JAVALANGREFREFERENCE_STATE = 0;
		J9VMCONSTANTPOOL_JAVALANGREFSOFTREFERENCE = 0;
		J9VMCONSTANTPOOL_JAVALANGREFSOFTREFERENCE_AGE = 0;
		J9VMCONSTANTPOOL_JAVALANGSECURITYEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGSHORT = 0;
		J9VMCONSTANTPOOL_JAVALANGSHORT_VALUE = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKOVERFLOWERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_CLASSLOADERNAME = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_DECLARINGCLASS = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_FILENAME = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_INCLUDECLASSLOADERNAME = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_INCLUDEMODULEVERSION = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_LINENUMBER = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_METHODNAME = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_MODULENAME = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_MODULEVERSION = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_SOURCE = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_BYTECODEINDEX = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_CALLERSENSITIVE = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_CLASSLOADERNAME = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_CLASSNAME = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_DECLARINGCLASS = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_FILENAME = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_FRAMEMODULE = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_LINENUMBER = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_METHODNAME = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_METHODSIGNATURE = 0;
		J9VMCONSTANTPOOL_JAVALANGSTRING = 0;
		J9VMCONSTANTPOOL_JAVALANGSTRINGINDEXOUTOFBOUNDSEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGSTRINGSTRINGCOMPRESSIONFLAG = 0;
		J9VMCONSTANTPOOL_JAVALANGSTRING_CODER = 0;
		J9VMCONSTANTPOOL_JAVALANGSTRING_COMPRESSIONFLAG = 0;
		J9VMCONSTANTPOOL_JAVALANGSTRING_COUNT = 0;
		J9VMCONSTANTPOOL_JAVALANGSTRING_HASHCODE = 0;
		J9VMCONSTANTPOOL_JAVALANGSTRING_VALUE = 0;
		J9VMCONSTANTPOOL_JAVALANGSYSTEM = 0;
		J9VMCONSTANTPOOL_JAVALANGSYSTEM_SECURITY = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREAD = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREADDEATH = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREADGROUP = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREADGROUP_CHILDRENGROUPS = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREADGROUP_CHILDRENGROUPSLOCK = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREADGROUP_CHILDRENTHREADS = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREADGROUP_CHILDRENTHREADSLOCK = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREADGROUP_ISDAEMON = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREADGROUP_MAXPRIORITY = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREADGROUP_NAME = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREADGROUP_NUMGROUPS = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREADGROUP_NUMTHREADS = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREADGROUP_PARENT = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREAD_CONTEXTCLASSLOADER = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREAD_DEADINTERRUPT = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREAD_GROUP = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREAD_INHERITEDACCESSCONTROLCONTEXT = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREAD_INIT = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREAD_ISDAEMON = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREAD_LOCK = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREAD_NAME = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREAD_PARKBLOCKER = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREAD_PRIORITY = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREAD_RUNNABLE = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREAD_STACKSIZE = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREAD_STARTED = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREAD_STOPCALLED = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREAD_THREADREF = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREAD_TID = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREAD_UNCAUGHTEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGTHROWABLE = 0;
		J9VMCONSTANTPOOL_JAVALANGTHROWABLE_CAUSE = 0;
		J9VMCONSTANTPOOL_JAVALANGTHROWABLE_DETAILMESSAGE = 0;
		J9VMCONSTANTPOOL_JAVALANGTHROWABLE_DISABLEWRITABLESTACKTRACE = 0;
		J9VMCONSTANTPOOL_JAVALANGTHROWABLE_STACKTRACE = 0;
		J9VMCONSTANTPOOL_JAVALANGTHROWABLE_WALKBACK = 0;
		J9VMCONSTANTPOOL_JAVALANGUNSATISFIEDLINKERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGUNSUPPORTEDCLASSVERSIONERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGVERIFYERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGVIRTUALMACHINEERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGVOID = 0;
		J9VMCONSTANTPOOL_JAVAUTILCONCURRENTLOCKSABSTRACTOWNABLESYNCHRONIZER = 0;
		J9VMCONSTANTPOOL_JAVAUTILCONCURRENTLOCKSABSTRACTOWNABLESYNCHRONIZER_EXCLUSIVEOWNERTHREAD = 0;
		J9VMCONSTANTPOOL_JDKINTERNALLOADERNATIVELIBRARIES = 0;
		J9VMCONSTANTPOOL_JDKINTERNALLOADERNATIVELIBRARIESNATIVELIBRARYIMPL = 0;
		J9VMCONSTANTPOOL_JDKINTERNALLOADERNATIVELIBRARIESNATIVELIBRARYIMPL_FROMCLASS = 0;
		J9VMCONSTANTPOOL_JDKINTERNALLOADERNATIVELIBRARIES_LOAD = 0;
		J9VM_VMCONSTANTPOOL_SIZE = 0;
		JCL_RTFLAG_DEFAULT = 0;
		JCL_RTFLAG_INTERP_HOT_CODE_REPLACEMENT = 0;
		JCL_RTFLAG_JIT_NEW_INSTANCE_PROTOTYPE = 0;
		JCL_RTFLAG_OPT_METHOD_HANDLE = 0;
		JCL_RTFLAG_OPT_METHOD_HANDLE_COMMON = 0;
		JCL_RTFLAG_OPT_MODULE = 0;
		JCL_RTFLAG_OPT_OPENJDK_METHODHANDLE = 0;
		JCL_RTFLAG_OPT_PANAMA = 0;
		JCL_RTFLAG_OPT_REFLECT = 0;
	}

}
