/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9SharedClassJavacoreDataDescriptor
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9SharedClassJavacoreDataDescriptor {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _aotBytesOffset_;
	public static final int _aotClassChainDataBytesOffset_;
	public static final int _aotDataBytesOffset_;
	public static final int _aotThunkDataBytesOffset_;
	public static final int _cacheDirOffset_;
	public static final int _cacheEndAddressOffset_;
	public static final int _cacheGenOffset_;
	public static final int _cacheNameOffset_;
	public static final int _cacheSizeOffset_;
	public static final int _ccCountOffset_;
	public static final int _ccStartedCountOffset_;
	public static final int _corruptValueOffset_;
	public static final int _corruptionCodeOffset_;
	public static final int _debugAreaLineNumberTableBytesOffset_;
	public static final int _debugAreaLocalVariableTableBytesOffset_;
	public static final int _debugAreaSizeOffset_;
	public static final int _debugAreaUsedOffset_;
	public static final int _extraFlagsOffset_;
	public static final int _featureOffset_;
	public static final int _freeBytesOffset_;
	public static final int _indexedDataBytesOffset_;
	public static final int _jclDataBytesOffset_;
	public static final int _jitHintDataBytesOffset_;
	public static final int _jitProfileDataBytesOffset_;
	public static final int _maxAOTOffset_;
	public static final int _maxJITOffset_;
	public static final int _metadataStartOffset_;
	public static final int _minAOTOffset_;
	public static final int _minJITOffset_;
	public static final int _numAOTMethodsOffset_;
	public static final int _numAotClassChainsOffset_;
	public static final int _numAotDataEntriesOffset_;
	public static final int _numAotThunksOffset_;
	public static final int _numClasspathsOffset_;
	public static final int _numJclEntriesOffset_;
	public static final int _numJitHintsOffset_;
	public static final int _numJitProfilesOffset_;
	public static final int _numObjectsOffset_;
	public static final int _numROMClassesOffset_;
	public static final int _numStaleClassesOffset_;
	public static final int _numStartupHintsOffset_;
	public static final int _numTokensOffset_;
	public static final int _numURLsOffset_;
	public static final int _numZipCachesOffset_;
	public static final int _objectBytesOffset_;
	public static final int _otherBytesOffset_;
	public static final int _percFullOffset_;
	public static final int _percStaleOffset_;
	public static final int _readWriteBytesOffset_;
	public static final int _readWriteLockTIDOffset_;
	public static final int _romClassBytesOffset_;
	public static final int _romClassEndOffset_;
	public static final int _romClassStartOffset_;
	public static final int _runtimeFlagsOffset_;
	public static final int _semidOffset_;
	public static final int _shmidOffset_;
	public static final int _softMaxBytesOffset_;
	public static final int _startupHintBytesOffset_;
	public static final int _topLayerOffset_;
	public static final int _totalSizeOffset_;
	public static final int _unindexedDataBytesOffset_;
	public static final int _writeLockTIDOffset_;
	public static final int _zipCacheDataBytesOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_aotBytesOffset_ = 0;
		_aotClassChainDataBytesOffset_ = 0;
		_aotDataBytesOffset_ = 0;
		_aotThunkDataBytesOffset_ = 0;
		_cacheDirOffset_ = 0;
		_cacheEndAddressOffset_ = 0;
		_cacheGenOffset_ = 0;
		_cacheNameOffset_ = 0;
		_cacheSizeOffset_ = 0;
		_ccCountOffset_ = 0;
		_ccStartedCountOffset_ = 0;
		_corruptValueOffset_ = 0;
		_corruptionCodeOffset_ = 0;
		_debugAreaLineNumberTableBytesOffset_ = 0;
		_debugAreaLocalVariableTableBytesOffset_ = 0;
		_debugAreaSizeOffset_ = 0;
		_debugAreaUsedOffset_ = 0;
		_extraFlagsOffset_ = 0;
		_featureOffset_ = 0;
		_freeBytesOffset_ = 0;
		_indexedDataBytesOffset_ = 0;
		_jclDataBytesOffset_ = 0;
		_jitHintDataBytesOffset_ = 0;
		_jitProfileDataBytesOffset_ = 0;
		_maxAOTOffset_ = 0;
		_maxJITOffset_ = 0;
		_metadataStartOffset_ = 0;
		_minAOTOffset_ = 0;
		_minJITOffset_ = 0;
		_numAOTMethodsOffset_ = 0;
		_numAotClassChainsOffset_ = 0;
		_numAotDataEntriesOffset_ = 0;
		_numAotThunksOffset_ = 0;
		_numClasspathsOffset_ = 0;
		_numJclEntriesOffset_ = 0;
		_numJitHintsOffset_ = 0;
		_numJitProfilesOffset_ = 0;
		_numObjectsOffset_ = 0;
		_numROMClassesOffset_ = 0;
		_numStaleClassesOffset_ = 0;
		_numStartupHintsOffset_ = 0;
		_numTokensOffset_ = 0;
		_numURLsOffset_ = 0;
		_numZipCachesOffset_ = 0;
		_objectBytesOffset_ = 0;
		_otherBytesOffset_ = 0;
		_percFullOffset_ = 0;
		_percStaleOffset_ = 0;
		_readWriteBytesOffset_ = 0;
		_readWriteLockTIDOffset_ = 0;
		_romClassBytesOffset_ = 0;
		_romClassEndOffset_ = 0;
		_romClassStartOffset_ = 0;
		_runtimeFlagsOffset_ = 0;
		_semidOffset_ = 0;
		_shmidOffset_ = 0;
		_softMaxBytesOffset_ = 0;
		_startupHintBytesOffset_ = 0;
		_topLayerOffset_ = 0;
		_totalSizeOffset_ = 0;
		_unindexedDataBytesOffset_ = 0;
		_writeLockTIDOffset_ = 0;
		_zipCacheDataBytesOffset_ = 0;
	}

}
