/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9SharedCacheHeader
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9SharedCacheHeader {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _aotBytesOffset_;
	public static final int _cacheFullFlagsOffset_;
	public static final int _ccInitCompleteOffset_;
	public static final int _containsCacheletsOffset_;
	public static final int _corruptFlagOffset_;
	public static final int _corruptFlagPtrOffset_;
	public static final int _corruptValueOffset_;
	public static final int _corruptionCodeOffset_;
	public static final int _crashCntrOffset_;
	public static final int _crcValidOffset_;
	public static final int _crcValueOffset_;
	public static final int _debugRegionSizeOffset_;
	public static final int _extraFlagsOffset_;
	public static final int _jitBytesOffset_;
	public static final int _lastMetadataTypeOffset_;
	public static final int _lineNumberTableNextSRPOffset_;
	public static final int _localVariableTableNextSRPOffset_;
	public static final int _lockedOffset_;
	public static final int _lockedPtrOffset_;
	public static final int _maxAOTOffset_;
	public static final int _maxJITOffset_;
	public static final int _minAOTOffset_;
	public static final int _minJITOffset_;
	public static final int _osPageSizeOffset_;
	public static final int _readWriteBytesOffset_;
	public static final int _readWriteCrashCntrOffset_;
	public static final int _readWriteFlagsOffset_;
	public static final int _readWriteRebuildCntrOffset_;
	public static final int _readWriteSRPOffset_;
	public static final int _readWriteVerifyCntrOffset_;
	public static final int _readerCountOffset_;
	public static final int _roundedPagesFlagOffset_;
	public static final int _segmentSRPOffset_;
	public static final int _sharedInternTableBytesOffset_;
	public static final int _sharedStringHeadOffset_;
	public static final int _sharedStringTailOffset_;
	public static final int _softMaxBytesOffset_;
	public static final int _totalBytesOffset_;
	public static final int _totalSharedStringNodesOffset_;
	public static final int _totalSharedStringWeightOffset_;
	public static final int _unused1Offset_;
	public static final int _unused10Offset_;
	public static final int _unused2Offset_;
	public static final int _unused3Offset_;
	public static final int _unused4Offset_;
	public static final int _unused5Offset_;
	public static final int _unused6Offset_;
	public static final int _unused8Offset_;
	public static final int _unused9Offset_;
	public static final int _updateCountOffset_;
	public static final int _updateCountPtrOffset_;
	public static final int _updateSRPOffset_;
	public static final int _vmCntrOffset_;
	public static final int _writeHashOffset_;
	public static final int _writerCountOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_aotBytesOffset_ = 0;
		_cacheFullFlagsOffset_ = 0;
		_ccInitCompleteOffset_ = 0;
		_containsCacheletsOffset_ = 0;
		_corruptFlagOffset_ = 0;
		_corruptFlagPtrOffset_ = 0;
		_corruptValueOffset_ = 0;
		_corruptionCodeOffset_ = 0;
		_crashCntrOffset_ = 0;
		_crcValidOffset_ = 0;
		_crcValueOffset_ = 0;
		_debugRegionSizeOffset_ = 0;
		_extraFlagsOffset_ = 0;
		_jitBytesOffset_ = 0;
		_lastMetadataTypeOffset_ = 0;
		_lineNumberTableNextSRPOffset_ = 0;
		_localVariableTableNextSRPOffset_ = 0;
		_lockedOffset_ = 0;
		_lockedPtrOffset_ = 0;
		_maxAOTOffset_ = 0;
		_maxJITOffset_ = 0;
		_minAOTOffset_ = 0;
		_minJITOffset_ = 0;
		_osPageSizeOffset_ = 0;
		_readWriteBytesOffset_ = 0;
		_readWriteCrashCntrOffset_ = 0;
		_readWriteFlagsOffset_ = 0;
		_readWriteRebuildCntrOffset_ = 0;
		_readWriteSRPOffset_ = 0;
		_readWriteVerifyCntrOffset_ = 0;
		_readerCountOffset_ = 0;
		_roundedPagesFlagOffset_ = 0;
		_segmentSRPOffset_ = 0;
		_sharedInternTableBytesOffset_ = 0;
		_sharedStringHeadOffset_ = 0;
		_sharedStringTailOffset_ = 0;
		_softMaxBytesOffset_ = 0;
		_totalBytesOffset_ = 0;
		_totalSharedStringNodesOffset_ = 0;
		_totalSharedStringWeightOffset_ = 0;
		_unused1Offset_ = 0;
		_unused10Offset_ = 0;
		_unused2Offset_ = 0;
		_unused3Offset_ = 0;
		_unused4Offset_ = 0;
		_unused5Offset_ = 0;
		_unused6Offset_ = 0;
		_unused8Offset_ = 0;
		_unused9Offset_ = 0;
		_updateCountOffset_ = 0;
		_updateCountPtrOffset_ = 0;
		_updateSRPOffset_ = 0;
		_vmCntrOffset_ = 0;
		_writeHashOffset_ = 0;
		_writerCountOffset_ = 0;
	}

}
