/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9ROMFieldOffsetWalkState
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9ROMFieldOffsetWalkState {

	// VM Constants

	public static final long SIZEOF;
	public static final long J9VM_FIELD_OFFSET_WALK_BACKFILL_FLAT_OBJECT_FIELD;
	public static final long J9VM_FIELD_OFFSET_WALK_BACKFILL_FLAT_SINGLE_FIELD;
	public static final long J9VM_FIELD_OFFSET_WALK_BACKFILL_OBJECT_FIELD;
	public static final long J9VM_FIELD_OFFSET_WALK_BACKFILL_SINGLE_FIELD;
	public static final long J9VM_FIELD_OFFSET_WALK_CALCULATE_INSTANCE_SIZE;
	public static final long J9VM_FIELD_OFFSET_WALK_INCLUDE_HIDDEN;
	public static final long J9VM_FIELD_OFFSET_WALK_INCLUDE_INSTANCE;
	public static final long J9VM_FIELD_OFFSET_WALK_INCLUDE_STATIC;
	public static final long J9VM_FIELD_OFFSET_WALK_MAXIMUM_HIDDEN_FIELDS_PER_CLASS;
	public static final long J9VM_FIELD_OFFSET_WALK_ONLY_OBJECT_SLOTS;
	public static final long J9VM_FIELD_OFFSET_WALK_PREINDEX_INTERFACE_FIELDS;

	// Offsets

	public static final int _backfillOffsetToUseOffset_;
	public static final int _doubleStaticsSeenOffset_;
	public static final int _doublesSeenOffset_;
	public static final int _fieldWalkStateOffset_;
	public static final int _finalizeLinkOffsetOffset_;
	public static final int _firstDoubleOffsetOffset_;
	public static final int _firstObjectOffsetOffset_;
	public static final int _firstSingleOffsetOffset_;
	public static final int _hiddenFinalizeLinkFieldOffset_;
	public static final int _hiddenInstanceFieldCountOffset_;
	public static final int _hiddenInstanceFieldWalkIndexOffset_;
	public static final int _hiddenInstanceFieldsOffset_;
	public static final int _hiddenLockwordFieldOffset_;
	public static final int _lockOffsetOffset_;
	public static final int _objectStaticsSeenOffset_;
	public static final int _objectsSeenOffset_;
	public static final int _resultOffset_;
	public static final int _romClassOffset_;
	public static final int _singleStaticsSeenOffset_;
	public static final int _singlesSeenOffset_;
	public static final int _vmOffset_;
	public static final int _walkFlagsOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		J9VM_FIELD_OFFSET_WALK_BACKFILL_FLAT_OBJECT_FIELD = 0;
		J9VM_FIELD_OFFSET_WALK_BACKFILL_FLAT_SINGLE_FIELD = 0;
		J9VM_FIELD_OFFSET_WALK_BACKFILL_OBJECT_FIELD = 0;
		J9VM_FIELD_OFFSET_WALK_BACKFILL_SINGLE_FIELD = 0;
		J9VM_FIELD_OFFSET_WALK_CALCULATE_INSTANCE_SIZE = 0;
		J9VM_FIELD_OFFSET_WALK_INCLUDE_HIDDEN = 0;
		J9VM_FIELD_OFFSET_WALK_INCLUDE_INSTANCE = 0;
		J9VM_FIELD_OFFSET_WALK_INCLUDE_STATIC = 0;
		J9VM_FIELD_OFFSET_WALK_MAXIMUM_HIDDEN_FIELDS_PER_CLASS = 0;
		J9VM_FIELD_OFFSET_WALK_ONLY_OBJECT_SLOTS = 0;
		J9VM_FIELD_OFFSET_WALK_PREINDEX_INTERFACE_FIELDS = 0;
		_backfillOffsetToUseOffset_ = 0;
		_doubleStaticsSeenOffset_ = 0;
		_doublesSeenOffset_ = 0;
		_fieldWalkStateOffset_ = 0;
		_finalizeLinkOffsetOffset_ = 0;
		_firstDoubleOffsetOffset_ = 0;
		_firstObjectOffsetOffset_ = 0;
		_firstSingleOffsetOffset_ = 0;
		_hiddenFinalizeLinkFieldOffset_ = 0;
		_hiddenInstanceFieldCountOffset_ = 0;
		_hiddenInstanceFieldWalkIndexOffset_ = 0;
		_hiddenInstanceFieldsOffset_ = 0;
		_hiddenLockwordFieldOffset_ = 0;
		_lockOffsetOffset_ = 0;
		_objectStaticsSeenOffset_ = 0;
		_objectsSeenOffset_ = 0;
		_resultOffset_ = 0;
		_romClassOffset_ = 0;
		_singleStaticsSeenOffset_ = 0;
		_singlesSeenOffset_ = 0;
		_vmOffset_ = 0;
		_walkFlagsOffset_ = 0;
	}

}
