/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9RAS
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9RAS {

	// VM Constants

	public static final long SIZEOF;
	public static final long J9RASMajorVersion;
	public static final long J9RASMinorVersion;
	public static final long J9RASVersion;

	// Offsets

	public static final int _bitpattern1Offset_;
	public static final int _bitpattern2Offset_;
	public static final int _buildIDOffset_;
	public static final int _cpusOffset_;
	public static final int _crashInfoOffset_;
	public static final int _ddrDataOffset_;
	public static final int _dumpTimeMillisOffset_;
	public static final int _dumpTimeNanosOffset_;
	public static final int _envOffset_;
	public static final int _environmentOffset_;
	public static final int _eyecatcherOffset_;
	public static final int _hostnameOffset_;
	public static final int _idOffsetOffset_;
	public static final int _ipAddressesOffset_;
	public static final int _lengthOffset_;
	public static final int _mainThreadOffsetOffset_;
	public static final int _memoryOffset_;
	public static final int _nextStatisticOffset_;
	public static final int _omrthreadNextOffsetOffset_;
	public static final int _osarchOffset_;
	public static final int _osnameOffset_;
	public static final int _osthreadOffsetOffset_;
	public static final int _osversionOffset_;
	public static final int _pidOffset_;
	public static final int _serviceLevelOffset_;
	public static final int _startTimeMillisOffset_;
	public static final int _startTimeNanosOffset_;
	public static final int _systemInfoOffset_;
	public static final int _tidOffset_;
	public static final int _typedefsOffset_;
	public static final int _typedefsLenOffset_;
	public static final int _versionOffset_;
	public static final int _vmOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		J9RASMajorVersion = 0;
		J9RASMinorVersion = 0;
		J9RASVersion = 0;
		_bitpattern1Offset_ = 0;
		_bitpattern2Offset_ = 0;
		_buildIDOffset_ = 0;
		_cpusOffset_ = 0;
		_crashInfoOffset_ = 0;
		_ddrDataOffset_ = 0;
		_dumpTimeMillisOffset_ = 0;
		_dumpTimeNanosOffset_ = 0;
		_envOffset_ = 0;
		_environmentOffset_ = 0;
		_eyecatcherOffset_ = 0;
		_hostnameOffset_ = 0;
		_idOffsetOffset_ = 0;
		_ipAddressesOffset_ = 0;
		_lengthOffset_ = 0;
		_mainThreadOffsetOffset_ = 0;
		_memoryOffset_ = 0;
		_nextStatisticOffset_ = 0;
		_omrthreadNextOffsetOffset_ = 0;
		_osarchOffset_ = 0;
		_osnameOffset_ = 0;
		_osthreadOffsetOffset_ = 0;
		_osversionOffset_ = 0;
		_pidOffset_ = 0;
		_serviceLevelOffset_ = 0;
		_startTimeMillisOffset_ = 0;
		_startTimeNanosOffset_ = 0;
		_systemInfoOffset_ = 0;
		_tidOffset_ = 0;
		_typedefsOffset_ = 0;
		_typedefsLenOffset_ = 0;
		_versionOffset_ = 0;
		_vmOffset_ = 0;
	}

}
