/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9ProcessorArchitecture
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9ProcessorArchitecture {

	// VM Constants

	public static final long SIZEOF;
	public static final long PROCESOR_RISCV64_UNKNOWN;
	public static final long PROCESSOR_DUMMY;
	public static final long PROCESSOR_PPC_7XX;
	public static final long PROCESSOR_PPC_GP;
	public static final long PROCESSOR_PPC_GR;
	public static final long PROCESSOR_PPC_NSTAR;
	public static final long PROCESSOR_PPC_P10;
	public static final long PROCESSOR_PPC_P6;
	public static final long PROCESSOR_PPC_P7;
	public static final long PROCESSOR_PPC_P8;
	public static final long PROCESSOR_PPC_P9;
	public static final long PROCESSOR_PPC_PULSAR;
	public static final long PROCESSOR_PPC_PWR403;
	public static final long PROCESSOR_PPC_PWR405;
	public static final long PROCESSOR_PPC_PWR440;
	public static final long PROCESSOR_PPC_PWR601;
	public static final long PROCESSOR_PPC_PWR602;
	public static final long PROCESSOR_PPC_PWR603;
	public static final long PROCESSOR_PPC_PWR604;
	public static final long PROCESSOR_PPC_PWR620;
	public static final long PROCESSOR_PPC_PWR630;
	public static final long PROCESSOR_PPC_RIOS1;
	public static final long PROCESSOR_PPC_RIOS2;
	public static final long PROCESSOR_PPC_UNKNOWN;
	public static final long PROCESSOR_S390_GP10;
	public static final long PROCESSOR_S390_GP11;
	public static final long PROCESSOR_S390_GP12;
	public static final long PROCESSOR_S390_GP13;
	public static final long PROCESSOR_S390_GP14;
	public static final long PROCESSOR_S390_GP6;
	public static final long PROCESSOR_S390_GP7;
	public static final long PROCESSOR_S390_GP8;
	public static final long PROCESSOR_S390_GP9;
	public static final long PROCESSOR_S390_UNKNOWN;
	public static final long PROCESSOR_UNDEFINED;
	public static final long PROCESSOR_X86_AMDATHLONDURON;
	public static final long PROCESSOR_X86_AMDK5;
	public static final long PROCESSOR_X86_AMDK6;
	public static final long PROCESSOR_X86_AMDOPTERON;
	public static final long PROCESSOR_X86_INTELCORE2;
	public static final long PROCESSOR_X86_INTELHASWELL;
	public static final long PROCESSOR_X86_INTELNEHALEM;
	public static final long PROCESSOR_X86_INTELP6;
	public static final long PROCESSOR_X86_INTELPENTIUM;
	public static final long PROCESSOR_X86_INTELPENTIUM4;
	public static final long PROCESSOR_X86_INTELSANDYBRIDGE;
	public static final long PROCESSOR_X86_INTELTULSA;
	public static final long PROCESSOR_X86_INTELWESTMERE;
	public static final long PROCESSOR_X86_UNKNOWN;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		PROCESOR_RISCV64_UNKNOWN = 0;
		PROCESSOR_DUMMY = 0;
		PROCESSOR_PPC_7XX = 0;
		PROCESSOR_PPC_GP = 0;
		PROCESSOR_PPC_GR = 0;
		PROCESSOR_PPC_NSTAR = 0;
		PROCESSOR_PPC_P10 = 0;
		PROCESSOR_PPC_P6 = 0;
		PROCESSOR_PPC_P7 = 0;
		PROCESSOR_PPC_P8 = 0;
		PROCESSOR_PPC_P9 = 0;
		PROCESSOR_PPC_PULSAR = 0;
		PROCESSOR_PPC_PWR403 = 0;
		PROCESSOR_PPC_PWR405 = 0;
		PROCESSOR_PPC_PWR440 = 0;
		PROCESSOR_PPC_PWR601 = 0;
		PROCESSOR_PPC_PWR602 = 0;
		PROCESSOR_PPC_PWR603 = 0;
		PROCESSOR_PPC_PWR604 = 0;
		PROCESSOR_PPC_PWR620 = 0;
		PROCESSOR_PPC_PWR630 = 0;
		PROCESSOR_PPC_RIOS1 = 0;
		PROCESSOR_PPC_RIOS2 = 0;
		PROCESSOR_PPC_UNKNOWN = 0;
		PROCESSOR_S390_GP10 = 0;
		PROCESSOR_S390_GP11 = 0;
		PROCESSOR_S390_GP12 = 0;
		PROCESSOR_S390_GP13 = 0;
		PROCESSOR_S390_GP14 = 0;
		PROCESSOR_S390_GP6 = 0;
		PROCESSOR_S390_GP7 = 0;
		PROCESSOR_S390_GP8 = 0;
		PROCESSOR_S390_GP9 = 0;
		PROCESSOR_S390_UNKNOWN = 0;
		PROCESSOR_UNDEFINED = 0;
		PROCESSOR_X86_AMDATHLONDURON = 0;
		PROCESSOR_X86_AMDK5 = 0;
		PROCESSOR_X86_AMDK6 = 0;
		PROCESSOR_X86_AMDOPTERON = 0;
		PROCESSOR_X86_INTELCORE2 = 0;
		PROCESSOR_X86_INTELHASWELL = 0;
		PROCESSOR_X86_INTELNEHALEM = 0;
		PROCESSOR_X86_INTELP6 = 0;
		PROCESSOR_X86_INTELPENTIUM = 0;
		PROCESSOR_X86_INTELPENTIUM4 = 0;
		PROCESSOR_X86_INTELSANDYBRIDGE = 0;
		PROCESSOR_X86_INTELTULSA = 0;
		PROCESSOR_X86_INTELWESTMERE = 0;
		PROCESSOR_X86_UNKNOWN = 0;
	}

}
