/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9NonbuilderConstants
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9NonbuilderConstants {

	// VM Constants

	public static final long SIZEOF;
	public static final long CLASSNAME_INVALID;
	public static final long CLASSNAME_VALID;
	public static final long CLASSNAME_VALID_ARRARY;
	public static final long CLASSNAME_VALID_NON_ARRARY;
	public static final long J9VM_ASYNC_MAX_HANDLERS;
	public static final long J9VM_DLT_HISTORY_SIZE;
	public static final long J9VM_MAX_HIDDEN_FIELDS_PER_CLASS;
	public static final long J9VM_OBJECT_MONITOR_CACHE_SIZE;
	public static final long J9_CATCHTYPE_VALUE_FOR_SYNTHETIC_HANDLER_2BYTES;
	public static final long J9_CATCHTYPE_VALUE_FOR_SYNTHETIC_HANDLER_4BYTES;
	public static final long J9_ROMCLASS_OPTINFO_CLASS_ANNOTATION_INFO;
	public static final long J9_ROMCLASS_OPTINFO_ENCLOSING_METHOD;
	public static final long J9_ROMCLASS_OPTINFO_GENERIC_SIGNATURE;
	public static final long J9_ROMCLASS_OPTINFO_LOCAL;
	public static final long J9_ROMCLASS_OPTINFO_PERMITTEDSUBCLASSES_ATTRIBUTE;
	public static final long J9_ROMCLASS_OPTINFO_RECORD_ATTRIBUTE;
	public static final long J9_ROMCLASS_OPTINFO_REMOTE;
	public static final long J9_ROMCLASS_OPTINFO_SIMPLE_NAME;
	public static final long J9_ROMCLASS_OPTINFO_SOURCE_DEBUG_EXTENSION;
	public static final long J9_ROMCLASS_OPTINFO_SOURCE_FILE_NAME;
	public static final long J9_ROMCLASS_OPTINFO_TYPE_ANNOTATION_INFO;
	public static final long J9_ROMCLASS_OPTINFO_TYPE_TABLE;
	public static final long J9_ROMCLASS_OPTINFO_UNUSED;
	public static final long J9_ROMCLASS_OPTINFO_UNUSED_100000;
	public static final long J9_ROMCLASS_OPTINFO_UNUSED_20000;
	public static final long J9_ROMCLASS_OPTINFO_UNUSED_40000;
	public static final long J9_ROMCLASS_OPTINFO_UNUSED_80000;
	public static final long J9_ROMCLASS_OPTINFO_VARIABLE_TABLE_HAS_GENERIC;
	public static final long J9_ROMCLASS_OPTINFO_VERIFY_EXCLUDE;
	public static final long J9_VISIBILITY_ALLOWED;
	public static final long J9_VISIBILITY_MODULE_PACKAGE_EXPORT_ERROR;
	public static final long J9_VISIBILITY_MODULE_READ_ACCESS_ERROR;
	public static final long J9_VISIBILITY_NEST_HOST_DIFFERENT_PACKAGE_ERROR;
	public static final long J9_VISIBILITY_NEST_HOST_LOADING_FAILURE_ERROR;
	public static final long J9_VISIBILITY_NEST_MEMBER_NOT_CLAIMED_ERROR;
	public static final long J9_VISIBILITY_NON_MODULE_ACCESS_ERROR;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		CLASSNAME_INVALID = 0;
		CLASSNAME_VALID = 0;
		CLASSNAME_VALID_ARRARY = 0;
		CLASSNAME_VALID_NON_ARRARY = 0;
		J9VM_ASYNC_MAX_HANDLERS = 0;
		J9VM_DLT_HISTORY_SIZE = 0;
		J9VM_MAX_HIDDEN_FIELDS_PER_CLASS = 0;
		J9VM_OBJECT_MONITOR_CACHE_SIZE = 0;
		J9_CATCHTYPE_VALUE_FOR_SYNTHETIC_HANDLER_2BYTES = 0;
		J9_CATCHTYPE_VALUE_FOR_SYNTHETIC_HANDLER_4BYTES = 0;
		J9_ROMCLASS_OPTINFO_CLASS_ANNOTATION_INFO = 0;
		J9_ROMCLASS_OPTINFO_ENCLOSING_METHOD = 0;
		J9_ROMCLASS_OPTINFO_GENERIC_SIGNATURE = 0;
		J9_ROMCLASS_OPTINFO_LOCAL = 0;
		J9_ROMCLASS_OPTINFO_PERMITTEDSUBCLASSES_ATTRIBUTE = 0;
		J9_ROMCLASS_OPTINFO_RECORD_ATTRIBUTE = 0;
		J9_ROMCLASS_OPTINFO_REMOTE = 0;
		J9_ROMCLASS_OPTINFO_SIMPLE_NAME = 0;
		J9_ROMCLASS_OPTINFO_SOURCE_DEBUG_EXTENSION = 0;
		J9_ROMCLASS_OPTINFO_SOURCE_FILE_NAME = 0;
		J9_ROMCLASS_OPTINFO_TYPE_ANNOTATION_INFO = 0;
		J9_ROMCLASS_OPTINFO_TYPE_TABLE = 0;
		J9_ROMCLASS_OPTINFO_UNUSED = 0;
		J9_ROMCLASS_OPTINFO_UNUSED_100000 = 0;
		J9_ROMCLASS_OPTINFO_UNUSED_20000 = 0;
		J9_ROMCLASS_OPTINFO_UNUSED_40000 = 0;
		J9_ROMCLASS_OPTINFO_UNUSED_80000 = 0;
		J9_ROMCLASS_OPTINFO_VARIABLE_TABLE_HAS_GENERIC = 0;
		J9_ROMCLASS_OPTINFO_VERIFY_EXCLUDE = 0;
		J9_VISIBILITY_ALLOWED = 0;
		J9_VISIBILITY_MODULE_PACKAGE_EXPORT_ERROR = 0;
		J9_VISIBILITY_MODULE_READ_ACCESS_ERROR = 0;
		J9_VISIBILITY_NEST_HOST_DIFFERENT_PACKAGE_ERROR = 0;
		J9_VISIBILITY_NEST_HOST_LOADING_FAILURE_ERROR = 0;
		J9_VISIBILITY_NEST_MEMBER_NOT_CLAIMED_ERROR = 0;
		J9_VISIBILITY_NON_MODULE_ACCESS_ERROR = 0;
	}

}
