/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9ModroncoreConstants
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9ModroncoreConstants {

	// VM Constants

	public static final long SIZEOF;
	public static final long CARD_CLEAN;
	public static final long CARD_DIRTY;
	public static final long CARD_GMP_MUST_SCAN;
	public static final long CARD_INVALID;
	public static final long CARD_MARK_COMPACT_TRANSITION;
	public static final long CARD_PGC_MUST_SCAN;
	public static final long CARD_REMEMBERED;
	public static final long CARD_REMEMBERED_AND_GMP_SCAN;
	public static final long CARD_SIZE;
	public static final long CARD_SIZE_SHIFT;
	public static final long J9VMSTATE_GC;
	public static final long OMRVMSTATE_GC_ALLOCATE_INDEXABLE_OBJECT;
	public static final long OMRVMSTATE_GC_ALLOCATE_OBJECT;
	public static final long OMRVMSTATE_GC_CARD_CLEANER_FOR_MARKING;
	public static final long OMRVMSTATE_GC_CHECK_AFTER_GC;
	public static final long OMRVMSTATE_GC_CHECK_BEFORE_GC;
	public static final long OMRVMSTATE_GC_CHECK_RESIZE;
	public static final long OMRVMSTATE_GC_CLEANING_METADATA;
	public static final long OMRVMSTATE_GC_COLLECTOR_CONCURRENTGC;
	public static final long OMRVMSTATE_GC_COLLECTOR_CONCURRENTSWEEPGC;
	public static final long OMRVMSTATE_GC_COLLECTOR_GLOBALGC;
	public static final long OMRVMSTATE_GC_COLLECTOR_METRONOME;
	public static final long OMRVMSTATE_GC_COLLECTOR_SCAVENGER;
	public static final long OMRVMSTATE_GC_COMPACT;
	public static final long OMRVMSTATE_GC_COMPACT_FIX_HEAP_FOR_WALK;
	public static final long OMRVMSTATE_GC_CONCURRENT_MARK_CLEAR_NEW_MARKBITS;
	public static final long OMRVMSTATE_GC_CONCURRENT_MARK_COMPLETE_TRACING;
	public static final long OMRVMSTATE_GC_CONCURRENT_MARK_FINAL_CLEAN_CARDS;
	public static final long OMRVMSTATE_GC_CONCURRENT_MARK_PREPARE_CARD_TABLE;
	public static final long OMRVMSTATE_GC_CONCURRENT_MARK_SCAN_REMEMBERED_SET;
	public static final long OMRVMSTATE_GC_CONCURRENT_MARK_TRACE;
	public static final long OMRVMSTATE_GC_CONCURRENT_SCAVENGER;
	public static final long OMRVMSTATE_GC_CONCURRENT_SWEEP;
	public static final long OMRVMSTATE_GC_CONCURRENT_SWEEP_COMPLETE_SWEEP;
	public static final long OMRVMSTATE_GC_CONCURRENT_SWEEP_FIND_MINIMUM_SIZE_FREE;
	public static final long OMRVMSTATE_GC_COPY_FORWARD_GMP_CARD_CLEANER;
	public static final long OMRVMSTATE_GC_COPY_FORWARD_NO_GMP_CARD_CLEANER;
	public static final long OMRVMSTATE_GC_DISPATCHER_IDLE;
	public static final long OMRVMSTATE_GC_GLOBAL_COLLECTION_CARD_CLEANER;
	public static final long OMRVMSTATE_GC_GLOBAL_COLLECTION_NO_SCAN_CARD_CLEANER;
	public static final long OMRVMSTATE_GC_GLOBAL_MARK_CARD_CLEANER;
	public static final long OMRVMSTATE_GC_GLOBAL_MARK_CARD_SCRUBBER;
	public static final long OMRVMSTATE_GC_GLOBAL_MARK_NO_SCAN_CARD_CLEANER;
	public static final long OMRVMSTATE_GC_MARK;
	public static final long OMRVMSTATE_GC_PARALLEL_OBJECT_DO;
	public static final long OMRVMSTATE_GC_PARTIAL_MARK_GMP_CARD_CLEANER;
	public static final long OMRVMSTATE_GC_PARTIAL_MARK_NO_GMP_CARD_CLEANER;
	public static final long OMRVMSTATE_GC_PERFORM_RESIZE;
	public static final long OMRVMSTATE_GC_SCAVENGE;
	public static final long OMRVMSTATE_GC_SCRUB_CARD_TABLE;
	public static final long OMRVMSTATE_GC_SWEEP;
	public static final long OMRVMSTATE_GC_TGC;
	public static final long OMRVMSTATE_GC_THIS_STATE_CAN_BE_REUSED_0001;
	public static final long OMRVMSTATE_GC_THIS_STATE_CAN_BE_REUSED_0005;
	public static final long OMRVMSTATE_GC_THIS_STATE_CAN_BE_REUSED_000E;
	public static final long OMRVMSTATE_GC_THIS_STATE_CAN_BE_REUSED_001B;
	public static final long OMRVMSTATE_GC_THIS_STATE_CAN_BE_REUSED_001C;
	public static final long OMRVMSTATE_GC_THIS_STATE_CAN_BE_REUSED_001D;
	public static final long OMRVMSTATE_GC_THIS_STATE_CAN_BE_REUSED_001F;
	public static final long OMRVMSTATE_GC_WRITE_ONCE_FIXUP_CARD_CLEANER;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		CARD_CLEAN = 0;
		CARD_DIRTY = 0;
		CARD_GMP_MUST_SCAN = 0;
		CARD_INVALID = 0;
		CARD_MARK_COMPACT_TRANSITION = 0;
		CARD_PGC_MUST_SCAN = 0;
		CARD_REMEMBERED = 0;
		CARD_REMEMBERED_AND_GMP_SCAN = 0;
		CARD_SIZE = 0;
		CARD_SIZE_SHIFT = 0;
		J9VMSTATE_GC = 0;
		OMRVMSTATE_GC_ALLOCATE_INDEXABLE_OBJECT = 0;
		OMRVMSTATE_GC_ALLOCATE_OBJECT = 0;
		OMRVMSTATE_GC_CARD_CLEANER_FOR_MARKING = 0;
		OMRVMSTATE_GC_CHECK_AFTER_GC = 0;
		OMRVMSTATE_GC_CHECK_BEFORE_GC = 0;
		OMRVMSTATE_GC_CHECK_RESIZE = 0;
		OMRVMSTATE_GC_CLEANING_METADATA = 0;
		OMRVMSTATE_GC_COLLECTOR_CONCURRENTGC = 0;
		OMRVMSTATE_GC_COLLECTOR_CONCURRENTSWEEPGC = 0;
		OMRVMSTATE_GC_COLLECTOR_GLOBALGC = 0;
		OMRVMSTATE_GC_COLLECTOR_METRONOME = 0;
		OMRVMSTATE_GC_COLLECTOR_SCAVENGER = 0;
		OMRVMSTATE_GC_COMPACT = 0;
		OMRVMSTATE_GC_COMPACT_FIX_HEAP_FOR_WALK = 0;
		OMRVMSTATE_GC_CONCURRENT_MARK_CLEAR_NEW_MARKBITS = 0;
		OMRVMSTATE_GC_CONCURRENT_MARK_COMPLETE_TRACING = 0;
		OMRVMSTATE_GC_CONCURRENT_MARK_FINAL_CLEAN_CARDS = 0;
		OMRVMSTATE_GC_CONCURRENT_MARK_PREPARE_CARD_TABLE = 0;
		OMRVMSTATE_GC_CONCURRENT_MARK_SCAN_REMEMBERED_SET = 0;
		OMRVMSTATE_GC_CONCURRENT_MARK_TRACE = 0;
		OMRVMSTATE_GC_CONCURRENT_SCAVENGER = 0;
		OMRVMSTATE_GC_CONCURRENT_SWEEP = 0;
		OMRVMSTATE_GC_CONCURRENT_SWEEP_COMPLETE_SWEEP = 0;
		OMRVMSTATE_GC_CONCURRENT_SWEEP_FIND_MINIMUM_SIZE_FREE = 0;
		OMRVMSTATE_GC_COPY_FORWARD_GMP_CARD_CLEANER = 0;
		OMRVMSTATE_GC_COPY_FORWARD_NO_GMP_CARD_CLEANER = 0;
		OMRVMSTATE_GC_DISPATCHER_IDLE = 0;
		OMRVMSTATE_GC_GLOBAL_COLLECTION_CARD_CLEANER = 0;
		OMRVMSTATE_GC_GLOBAL_COLLECTION_NO_SCAN_CARD_CLEANER = 0;
		OMRVMSTATE_GC_GLOBAL_MARK_CARD_CLEANER = 0;
		OMRVMSTATE_GC_GLOBAL_MARK_CARD_SCRUBBER = 0;
		OMRVMSTATE_GC_GLOBAL_MARK_NO_SCAN_CARD_CLEANER = 0;
		OMRVMSTATE_GC_MARK = 0;
		OMRVMSTATE_GC_PARALLEL_OBJECT_DO = 0;
		OMRVMSTATE_GC_PARTIAL_MARK_GMP_CARD_CLEANER = 0;
		OMRVMSTATE_GC_PARTIAL_MARK_NO_GMP_CARD_CLEANER = 0;
		OMRVMSTATE_GC_PERFORM_RESIZE = 0;
		OMRVMSTATE_GC_SCAVENGE = 0;
		OMRVMSTATE_GC_SCRUB_CARD_TABLE = 0;
		OMRVMSTATE_GC_SWEEP = 0;
		OMRVMSTATE_GC_TGC = 0;
		OMRVMSTATE_GC_THIS_STATE_CAN_BE_REUSED_0001 = 0;
		OMRVMSTATE_GC_THIS_STATE_CAN_BE_REUSED_0005 = 0;
		OMRVMSTATE_GC_THIS_STATE_CAN_BE_REUSED_000E = 0;
		OMRVMSTATE_GC_THIS_STATE_CAN_BE_REUSED_001B = 0;
		OMRVMSTATE_GC_THIS_STATE_CAN_BE_REUSED_001C = 0;
		OMRVMSTATE_GC_THIS_STATE_CAN_BE_REUSED_001D = 0;
		OMRVMSTATE_GC_THIS_STATE_CAN_BE_REUSED_001F = 0;
		OMRVMSTATE_GC_WRITE_ONCE_FIXUP_CARD_CLEANER = 0;
	}

}
