/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9HashTable
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9HashTable {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _avlTreeTemplateOffset_;
	public static final int _entrySizeOffset_;
	public static final int _equalFnUserDataOffset_;
	public static final int _flagsOffset_;
	public static final int _hashEqualFnOffset_;
	public static final int _hashFnOffset_;
	public static final int _hashFnUserDataOffset_;
	public static final int _listNodePoolOffset_;
	public static final int _listNodeSizeOffset_;
	public static final int _listToTreeThresholdOffset_;
	public static final int _memoryCategoryOffset_;
	public static final int _nodeAlignmentOffset_;
	public static final int _nodesOffset_;
	public static final int _numberOfNodesOffset_;
	public static final int _numberOfTreeNodesOffset_;
	public static final int _portLibraryOffset_;
	public static final int _previousOffset_;
	public static final int _printFnOffset_;
	public static final int _tableNameOffset_;
	public static final int _tableSizeOffset_;
	public static final int _treeNodePoolOffset_;
	public static final int _treeNodeSizeOffset_;
	public static final int _treePoolOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_avlTreeTemplateOffset_ = 0;
		_entrySizeOffset_ = 0;
		_equalFnUserDataOffset_ = 0;
		_flagsOffset_ = 0;
		_hashEqualFnOffset_ = 0;
		_hashFnOffset_ = 0;
		_hashFnUserDataOffset_ = 0;
		_listNodePoolOffset_ = 0;
		_listNodeSizeOffset_ = 0;
		_listToTreeThresholdOffset_ = 0;
		_memoryCategoryOffset_ = 0;
		_nodeAlignmentOffset_ = 0;
		_nodesOffset_ = 0;
		_numberOfNodesOffset_ = 0;
		_numberOfTreeNodesOffset_ = 0;
		_portLibraryOffset_ = 0;
		_previousOffset_ = 0;
		_printFnOffset_ = 0;
		_tableNameOffset_ = 0;
		_tableSizeOffset_ = 0;
		_treeNodePoolOffset_ = 0;
		_treeNodeSizeOffset_ = 0;
		_treePoolOffset_ = 0;
	}

}
