/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9CfrMethod
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9CfrMethod {

	// VM Constants

	public static final long SIZEOF;
	public static final long CFR_BC_aaload;
	public static final long CFR_BC_aastore;
	public static final long CFR_BC_aconst_null;
	public static final long CFR_BC_aload;
	public static final long CFR_BC_aload_0;
	public static final long CFR_BC_aload_1;
	public static final long CFR_BC_aload_2;
	public static final long CFR_BC_aload_3;
	public static final long CFR_BC_anewarray;
	public static final long CFR_BC_areturn;
	public static final long CFR_BC_arraylength;
	public static final long CFR_BC_astore;
	public static final long CFR_BC_astore_0;
	public static final long CFR_BC_astore_1;
	public static final long CFR_BC_astore_2;
	public static final long CFR_BC_astore_3;
	public static final long CFR_BC_athrow;
	public static final long CFR_BC_baload;
	public static final long CFR_BC_bastore;
	public static final long CFR_BC_bipush;
	public static final long CFR_BC_breakpoint;
	public static final long CFR_BC_caload;
	public static final long CFR_BC_castore;
	public static final long CFR_BC_checkcast;
	public static final long CFR_BC_d2f;
	public static final long CFR_BC_d2i;
	public static final long CFR_BC_d2l;
	public static final long CFR_BC_dadd;
	public static final long CFR_BC_daload;
	public static final long CFR_BC_dastore;
	public static final long CFR_BC_dcmpg;
	public static final long CFR_BC_dcmpl;
	public static final long CFR_BC_dconst_0;
	public static final long CFR_BC_dconst_1;
	public static final long CFR_BC_ddiv;
	public static final long CFR_BC_defaultvalue;
	public static final long CFR_BC_dload;
	public static final long CFR_BC_dload_0;
	public static final long CFR_BC_dload_1;
	public static final long CFR_BC_dload_2;
	public static final long CFR_BC_dload_3;
	public static final long CFR_BC_dmul;
	public static final long CFR_BC_dneg;
	public static final long CFR_BC_drem;
	public static final long CFR_BC_dreturn;
	public static final long CFR_BC_dstore;
	public static final long CFR_BC_dstore_0;
	public static final long CFR_BC_dstore_1;
	public static final long CFR_BC_dstore_2;
	public static final long CFR_BC_dstore_3;
	public static final long CFR_BC_dsub;
	public static final long CFR_BC_dup;
	public static final long CFR_BC_dup2;
	public static final long CFR_BC_dup2_x1;
	public static final long CFR_BC_dup2_x2;
	public static final long CFR_BC_dup_x1;
	public static final long CFR_BC_dup_x2;
	public static final long CFR_BC_f2d;
	public static final long CFR_BC_f2i;
	public static final long CFR_BC_f2l;
	public static final long CFR_BC_fadd;
	public static final long CFR_BC_faload;
	public static final long CFR_BC_fastore;
	public static final long CFR_BC_fcmpg;
	public static final long CFR_BC_fcmpl;
	public static final long CFR_BC_fconst_0;
	public static final long CFR_BC_fconst_1;
	public static final long CFR_BC_fconst_2;
	public static final long CFR_BC_fdiv;
	public static final long CFR_BC_fload;
	public static final long CFR_BC_fload_0;
	public static final long CFR_BC_fload_1;
	public static final long CFR_BC_fload_2;
	public static final long CFR_BC_fload_3;
	public static final long CFR_BC_fmul;
	public static final long CFR_BC_fneg;
	public static final long CFR_BC_frem;
	public static final long CFR_BC_freturn;
	public static final long CFR_BC_fstore;
	public static final long CFR_BC_fstore_0;
	public static final long CFR_BC_fstore_1;
	public static final long CFR_BC_fstore_2;
	public static final long CFR_BC_fstore_3;
	public static final long CFR_BC_fsub;
	public static final long CFR_BC_getfield;
	public static final long CFR_BC_getstatic;
	public static final long CFR_BC_goto;
	public static final long CFR_BC_goto_w;
	public static final long CFR_BC_i2b;
	public static final long CFR_BC_i2c;
	public static final long CFR_BC_i2d;
	public static final long CFR_BC_i2f;
	public static final long CFR_BC_i2l;
	public static final long CFR_BC_i2s;
	public static final long CFR_BC_iadd;
	public static final long CFR_BC_iaload;
	public static final long CFR_BC_iand;
	public static final long CFR_BC_iastore;
	public static final long CFR_BC_iconst_0;
	public static final long CFR_BC_iconst_1;
	public static final long CFR_BC_iconst_2;
	public static final long CFR_BC_iconst_3;
	public static final long CFR_BC_iconst_4;
	public static final long CFR_BC_iconst_5;
	public static final long CFR_BC_iconst_m1;
	public static final long CFR_BC_idiv;
	public static final long CFR_BC_if_acmpeq;
	public static final long CFR_BC_if_acmpne;
	public static final long CFR_BC_if_icmpeq;
	public static final long CFR_BC_if_icmpge;
	public static final long CFR_BC_if_icmpgt;
	public static final long CFR_BC_if_icmple;
	public static final long CFR_BC_if_icmplt;
	public static final long CFR_BC_if_icmpne;
	public static final long CFR_BC_ifeq;
	public static final long CFR_BC_ifge;
	public static final long CFR_BC_ifgt;
	public static final long CFR_BC_ifle;
	public static final long CFR_BC_iflt;
	public static final long CFR_BC_ifne;
	public static final long CFR_BC_ifnonnull;
	public static final long CFR_BC_ifnull;
	public static final long CFR_BC_iinc;
	public static final long CFR_BC_iload;
	public static final long CFR_BC_iload_0;
	public static final long CFR_BC_iload_1;
	public static final long CFR_BC_iload_2;
	public static final long CFR_BC_iload_3;
	public static final long CFR_BC_impdep1;
	public static final long CFR_BC_impdep2;
	public static final long CFR_BC_imul;
	public static final long CFR_BC_ineg;
	public static final long CFR_BC_instanceof;
	public static final long CFR_BC_invokedynamic;
	public static final long CFR_BC_invokehandle;
	public static final long CFR_BC_invokehandlegeneric;
	public static final long CFR_BC_invokeinterface;
	public static final long CFR_BC_invokespecial;
	public static final long CFR_BC_invokespecialsplit;
	public static final long CFR_BC_invokestatic;
	public static final long CFR_BC_invokestaticsplit;
	public static final long CFR_BC_invokevirtual;
	public static final long CFR_BC_ior;
	public static final long CFR_BC_irem;
	public static final long CFR_BC_ireturn;
	public static final long CFR_BC_ishl;
	public static final long CFR_BC_ishr;
	public static final long CFR_BC_istore;
	public static final long CFR_BC_istore_0;
	public static final long CFR_BC_istore_1;
	public static final long CFR_BC_istore_2;
	public static final long CFR_BC_istore_3;
	public static final long CFR_BC_isub;
	public static final long CFR_BC_iushr;
	public static final long CFR_BC_ixor;
	public static final long CFR_BC_jsr;
	public static final long CFR_BC_jsr_w;
	public static final long CFR_BC_l2d;
	public static final long CFR_BC_l2f;
	public static final long CFR_BC_l2i;
	public static final long CFR_BC_ladd;
	public static final long CFR_BC_laload;
	public static final long CFR_BC_land;
	public static final long CFR_BC_lastore;
	public static final long CFR_BC_lcmp;
	public static final long CFR_BC_lconst_0;
	public static final long CFR_BC_lconst_1;
	public static final long CFR_BC_ldc;
	public static final long CFR_BC_ldc2_w;
	public static final long CFR_BC_ldc_w;
	public static final long CFR_BC_ldiv;
	public static final long CFR_BC_lload;
	public static final long CFR_BC_lload_0;
	public static final long CFR_BC_lload_1;
	public static final long CFR_BC_lload_2;
	public static final long CFR_BC_lload_3;
	public static final long CFR_BC_lmul;
	public static final long CFR_BC_lneg;
	public static final long CFR_BC_lookupswitch;
	public static final long CFR_BC_lor;
	public static final long CFR_BC_lrem;
	public static final long CFR_BC_lreturn;
	public static final long CFR_BC_lshl;
	public static final long CFR_BC_lshr;
	public static final long CFR_BC_lstore;
	public static final long CFR_BC_lstore_0;
	public static final long CFR_BC_lstore_1;
	public static final long CFR_BC_lstore_2;
	public static final long CFR_BC_lstore_3;
	public static final long CFR_BC_lsub;
	public static final long CFR_BC_lushr;
	public static final long CFR_BC_lxor;
	public static final long CFR_BC_monitorenter;
	public static final long CFR_BC_monitorexit;
	public static final long CFR_BC_multianewarray;
	public static final long CFR_BC_new;
	public static final long CFR_BC_newarray;
	public static final long CFR_BC_nop;
	public static final long CFR_BC_pop;
	public static final long CFR_BC_pop2;
	public static final long CFR_BC_putfield;
	public static final long CFR_BC_putstatic;
	public static final long CFR_BC_ret;
	public static final long CFR_BC_return;
	public static final long CFR_BC_saload;
	public static final long CFR_BC_sastore;
	public static final long CFR_BC_sipush;
	public static final long CFR_BC_swap;
	public static final long CFR_BC_tableswitch;
	public static final long CFR_BC_wide;
	public static final long CFR_BC_withfield;

	// Offsets

	public static final int _accessFlagsOffset_;
	public static final int _attributesOffset_;
	public static final int _attributesCountOffset_;
	public static final int _codeAttributeOffset_;
	public static final int _descriptorIndexOffset_;
	public static final int _exceptionsAttributeOffset_;
	public static final int _j9ArgumentCountOffset_;
	public static final int _j9FlagsOffset_;
	public static final int _methodParametersAttributeOffset_;
	public static final int _nameIndexOffset_;
	public static final int _romAddressOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		CFR_BC_aaload = 0;
		CFR_BC_aastore = 0;
		CFR_BC_aconst_null = 0;
		CFR_BC_aload = 0;
		CFR_BC_aload_0 = 0;
		CFR_BC_aload_1 = 0;
		CFR_BC_aload_2 = 0;
		CFR_BC_aload_3 = 0;
		CFR_BC_anewarray = 0;
		CFR_BC_areturn = 0;
		CFR_BC_arraylength = 0;
		CFR_BC_astore = 0;
		CFR_BC_astore_0 = 0;
		CFR_BC_astore_1 = 0;
		CFR_BC_astore_2 = 0;
		CFR_BC_astore_3 = 0;
		CFR_BC_athrow = 0;
		CFR_BC_baload = 0;
		CFR_BC_bastore = 0;
		CFR_BC_bipush = 0;
		CFR_BC_breakpoint = 0;
		CFR_BC_caload = 0;
		CFR_BC_castore = 0;
		CFR_BC_checkcast = 0;
		CFR_BC_d2f = 0;
		CFR_BC_d2i = 0;
		CFR_BC_d2l = 0;
		CFR_BC_dadd = 0;
		CFR_BC_daload = 0;
		CFR_BC_dastore = 0;
		CFR_BC_dcmpg = 0;
		CFR_BC_dcmpl = 0;
		CFR_BC_dconst_0 = 0;
		CFR_BC_dconst_1 = 0;
		CFR_BC_ddiv = 0;
		CFR_BC_defaultvalue = 0;
		CFR_BC_dload = 0;
		CFR_BC_dload_0 = 0;
		CFR_BC_dload_1 = 0;
		CFR_BC_dload_2 = 0;
		CFR_BC_dload_3 = 0;
		CFR_BC_dmul = 0;
		CFR_BC_dneg = 0;
		CFR_BC_drem = 0;
		CFR_BC_dreturn = 0;
		CFR_BC_dstore = 0;
		CFR_BC_dstore_0 = 0;
		CFR_BC_dstore_1 = 0;
		CFR_BC_dstore_2 = 0;
		CFR_BC_dstore_3 = 0;
		CFR_BC_dsub = 0;
		CFR_BC_dup = 0;
		CFR_BC_dup2 = 0;
		CFR_BC_dup2_x1 = 0;
		CFR_BC_dup2_x2 = 0;
		CFR_BC_dup_x1 = 0;
		CFR_BC_dup_x2 = 0;
		CFR_BC_f2d = 0;
		CFR_BC_f2i = 0;
		CFR_BC_f2l = 0;
		CFR_BC_fadd = 0;
		CFR_BC_faload = 0;
		CFR_BC_fastore = 0;
		CFR_BC_fcmpg = 0;
		CFR_BC_fcmpl = 0;
		CFR_BC_fconst_0 = 0;
		CFR_BC_fconst_1 = 0;
		CFR_BC_fconst_2 = 0;
		CFR_BC_fdiv = 0;
		CFR_BC_fload = 0;
		CFR_BC_fload_0 = 0;
		CFR_BC_fload_1 = 0;
		CFR_BC_fload_2 = 0;
		CFR_BC_fload_3 = 0;
		CFR_BC_fmul = 0;
		CFR_BC_fneg = 0;
		CFR_BC_frem = 0;
		CFR_BC_freturn = 0;
		CFR_BC_fstore = 0;
		CFR_BC_fstore_0 = 0;
		CFR_BC_fstore_1 = 0;
		CFR_BC_fstore_2 = 0;
		CFR_BC_fstore_3 = 0;
		CFR_BC_fsub = 0;
		CFR_BC_getfield = 0;
		CFR_BC_getstatic = 0;
		CFR_BC_goto = 0;
		CFR_BC_goto_w = 0;
		CFR_BC_i2b = 0;
		CFR_BC_i2c = 0;
		CFR_BC_i2d = 0;
		CFR_BC_i2f = 0;
		CFR_BC_i2l = 0;
		CFR_BC_i2s = 0;
		CFR_BC_iadd = 0;
		CFR_BC_iaload = 0;
		CFR_BC_iand = 0;
		CFR_BC_iastore = 0;
		CFR_BC_iconst_0 = 0;
		CFR_BC_iconst_1 = 0;
		CFR_BC_iconst_2 = 0;
		CFR_BC_iconst_3 = 0;
		CFR_BC_iconst_4 = 0;
		CFR_BC_iconst_5 = 0;
		CFR_BC_iconst_m1 = 0;
		CFR_BC_idiv = 0;
		CFR_BC_if_acmpeq = 0;
		CFR_BC_if_acmpne = 0;
		CFR_BC_if_icmpeq = 0;
		CFR_BC_if_icmpge = 0;
		CFR_BC_if_icmpgt = 0;
		CFR_BC_if_icmple = 0;
		CFR_BC_if_icmplt = 0;
		CFR_BC_if_icmpne = 0;
		CFR_BC_ifeq = 0;
		CFR_BC_ifge = 0;
		CFR_BC_ifgt = 0;
		CFR_BC_ifle = 0;
		CFR_BC_iflt = 0;
		CFR_BC_ifne = 0;
		CFR_BC_ifnonnull = 0;
		CFR_BC_ifnull = 0;
		CFR_BC_iinc = 0;
		CFR_BC_iload = 0;
		CFR_BC_iload_0 = 0;
		CFR_BC_iload_1 = 0;
		CFR_BC_iload_2 = 0;
		CFR_BC_iload_3 = 0;
		CFR_BC_impdep1 = 0;
		CFR_BC_impdep2 = 0;
		CFR_BC_imul = 0;
		CFR_BC_ineg = 0;
		CFR_BC_instanceof = 0;
		CFR_BC_invokedynamic = 0;
		CFR_BC_invokehandle = 0;
		CFR_BC_invokehandlegeneric = 0;
		CFR_BC_invokeinterface = 0;
		CFR_BC_invokespecial = 0;
		CFR_BC_invokespecialsplit = 0;
		CFR_BC_invokestatic = 0;
		CFR_BC_invokestaticsplit = 0;
		CFR_BC_invokevirtual = 0;
		CFR_BC_ior = 0;
		CFR_BC_irem = 0;
		CFR_BC_ireturn = 0;
		CFR_BC_ishl = 0;
		CFR_BC_ishr = 0;
		CFR_BC_istore = 0;
		CFR_BC_istore_0 = 0;
		CFR_BC_istore_1 = 0;
		CFR_BC_istore_2 = 0;
		CFR_BC_istore_3 = 0;
		CFR_BC_isub = 0;
		CFR_BC_iushr = 0;
		CFR_BC_ixor = 0;
		CFR_BC_jsr = 0;
		CFR_BC_jsr_w = 0;
		CFR_BC_l2d = 0;
		CFR_BC_l2f = 0;
		CFR_BC_l2i = 0;
		CFR_BC_ladd = 0;
		CFR_BC_laload = 0;
		CFR_BC_land = 0;
		CFR_BC_lastore = 0;
		CFR_BC_lcmp = 0;
		CFR_BC_lconst_0 = 0;
		CFR_BC_lconst_1 = 0;
		CFR_BC_ldc = 0;
		CFR_BC_ldc2_w = 0;
		CFR_BC_ldc_w = 0;
		CFR_BC_ldiv = 0;
		CFR_BC_lload = 0;
		CFR_BC_lload_0 = 0;
		CFR_BC_lload_1 = 0;
		CFR_BC_lload_2 = 0;
		CFR_BC_lload_3 = 0;
		CFR_BC_lmul = 0;
		CFR_BC_lneg = 0;
		CFR_BC_lookupswitch = 0;
		CFR_BC_lor = 0;
		CFR_BC_lrem = 0;
		CFR_BC_lreturn = 0;
		CFR_BC_lshl = 0;
		CFR_BC_lshr = 0;
		CFR_BC_lstore = 0;
		CFR_BC_lstore_0 = 0;
		CFR_BC_lstore_1 = 0;
		CFR_BC_lstore_2 = 0;
		CFR_BC_lstore_3 = 0;
		CFR_BC_lsub = 0;
		CFR_BC_lushr = 0;
		CFR_BC_lxor = 0;
		CFR_BC_monitorenter = 0;
		CFR_BC_monitorexit = 0;
		CFR_BC_multianewarray = 0;
		CFR_BC_new = 0;
		CFR_BC_newarray = 0;
		CFR_BC_nop = 0;
		CFR_BC_pop = 0;
		CFR_BC_pop2 = 0;
		CFR_BC_putfield = 0;
		CFR_BC_putstatic = 0;
		CFR_BC_ret = 0;
		CFR_BC_return = 0;
		CFR_BC_saload = 0;
		CFR_BC_sastore = 0;
		CFR_BC_sipush = 0;
		CFR_BC_swap = 0;
		CFR_BC_tableswitch = 0;
		CFR_BC_wide = 0;
		CFR_BC_withfield = 0;
		_accessFlagsOffset_ = 0;
		_attributesOffset_ = 0;
		_attributesCountOffset_ = 0;
		_codeAttributeOffset_ = 0;
		_descriptorIndexOffset_ = 0;
		_exceptionsAttributeOffset_ = 0;
		_j9ArgumentCountOffset_ = 0;
		_j9FlagsOffset_ = 0;
		_methodParametersAttributeOffset_ = 0;
		_nameIndexOffset_ = 0;
		_romAddressOffset_ = 0;
	}

}
