/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9BytecodeVerificationData
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9BytecodeVerificationData {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _bytecodeMapOffset_;
	public static final int _bytecodeMapSizeOffset_;
	public static final int _checkClassLoadingConstraintForNameFunctionOffset_;
	public static final int _classLoaderOffset_;
	public static final int _classNameListOffset_;
	public static final int _classNameListEndOffset_;
	public static final int _classNameSegmentOffset_;
	public static final int _classNameSegmentEndOffset_;
	public static final int _classNameSegmentFreeOffset_;
	public static final int _createdStackMapOffset_;
	public static final int _currentAllocOffset_;
	public static final int _errorArgumentIndexOffset_;
	public static final int _errorClassStringOffset_;
	public static final int _errorCodeOffset_;
	public static final int _errorCurrentFramePositionOffset_;
	public static final int _errorDetailCodeOffset_;
	public static final int _errorMethodStringOffset_;
	public static final int _errorModuleOffset_;
	public static final int _errorPCOffset_;
	public static final int _errorSignatureStringOffset_;
	public static final int _errorTargetFrameIndexOffset_;
	public static final int _errorTargetTypeOffset_;
	public static final int _errorTempDataOffset_;
	public static final int _excludeAttributeOffset_;
	public static final int _ignoreStackMapsOffset_;
	public static final int _internalBufferEndOffset_;
	public static final int _internalBufferStartOffset_;
	public static final int _javaVMOffset_;
	public static final int _liveStackOffset_;
	public static final int _liveStackSizeOffset_;
	public static final int _portLibOffset_;
	public static final int _redefinedClassesOffset_;
	public static final int _redefinedClassesCountOffset_;
	public static final int _rewalkQueueOffset_;
	public static final int _rewalkQueueHeadOffset_;
	public static final int _rewalkQueueTailOffset_;
	public static final int _romClassOffset_;
	public static final int _romClassInSharedClassesOffset_;
	public static final int _romMethodOffset_;
	public static final int _rootQueueSizeOffset_;
	public static final int _stackMapsOffset_;
	public static final int _stackMapsCountOffset_;
	public static final int _stackMapsSizeOffset_;
	public static final int _stackSizeOffset_;
	public static final int _unwalkedQueueOffset_;
	public static final int _unwalkedQueueHeadOffset_;
	public static final int _unwalkedQueueTailOffset_;
	public static final int _verificationFlagsOffset_;
	public static final int _verifierMutexOffset_;
	public static final int _verifyBytecodesFunctionOffset_;
	public static final int _vmStructOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_bytecodeMapOffset_ = 0;
		_bytecodeMapSizeOffset_ = 0;
		_checkClassLoadingConstraintForNameFunctionOffset_ = 0;
		_classLoaderOffset_ = 0;
		_classNameListOffset_ = 0;
		_classNameListEndOffset_ = 0;
		_classNameSegmentOffset_ = 0;
		_classNameSegmentEndOffset_ = 0;
		_classNameSegmentFreeOffset_ = 0;
		_createdStackMapOffset_ = 0;
		_currentAllocOffset_ = 0;
		_errorArgumentIndexOffset_ = 0;
		_errorClassStringOffset_ = 0;
		_errorCodeOffset_ = 0;
		_errorCurrentFramePositionOffset_ = 0;
		_errorDetailCodeOffset_ = 0;
		_errorMethodStringOffset_ = 0;
		_errorModuleOffset_ = 0;
		_errorPCOffset_ = 0;
		_errorSignatureStringOffset_ = 0;
		_errorTargetFrameIndexOffset_ = 0;
		_errorTargetTypeOffset_ = 0;
		_errorTempDataOffset_ = 0;
		_excludeAttributeOffset_ = 0;
		_ignoreStackMapsOffset_ = 0;
		_internalBufferEndOffset_ = 0;
		_internalBufferStartOffset_ = 0;
		_javaVMOffset_ = 0;
		_liveStackOffset_ = 0;
		_liveStackSizeOffset_ = 0;
		_portLibOffset_ = 0;
		_redefinedClassesOffset_ = 0;
		_redefinedClassesCountOffset_ = 0;
		_rewalkQueueOffset_ = 0;
		_rewalkQueueHeadOffset_ = 0;
		_rewalkQueueTailOffset_ = 0;
		_romClassOffset_ = 0;
		_romClassInSharedClassesOffset_ = 0;
		_romMethodOffset_ = 0;
		_rootQueueSizeOffset_ = 0;
		_stackMapsOffset_ = 0;
		_stackMapsCountOffset_ = 0;
		_stackMapsSizeOffset_ = 0;
		_stackSizeOffset_ = 0;
		_unwalkedQueueOffset_ = 0;
		_unwalkedQueueHeadOffset_ = 0;
		_unwalkedQueueTailOffset_ = 0;
		_verificationFlagsOffset_ = 0;
		_verifierMutexOffset_ = 0;
		_verifyBytecodesFunctionOffset_ = 0;
		_vmStructOffset_ = 0;
	}

}
