/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: GC_ObjectModel$ScanType
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class GC_ObjectModel$ScanType {

	// VM Constants

	public static final long SIZEOF;
	public static final long SCAN_ATOMIC_MARKABLE_REFERENCE_OBJECT;
	public static final long SCAN_CLASSLOADER_OBJECT;
	public static final long SCAN_CLASS_OBJECT;
	public static final long SCAN_FLATTENED_ARRAY_OBJECT;
	public static final long SCAN_INVALID_OBJECT;
	public static final long SCAN_MIXED_OBJECT;
	public static final long SCAN_MIXED_OBJECT_LINKED;
	public static final long SCAN_OWNABLESYNCHRONIZER_OBJECT;
	public static final long SCAN_POINTER_ARRAY_OBJECT;
	public static final long SCAN_PRIMITIVE_ARRAY_OBJECT;
	public static final long SCAN_REFERENCE_MIXED_OBJECT;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		SCAN_ATOMIC_MARKABLE_REFERENCE_OBJECT = 0;
		SCAN_CLASSLOADER_OBJECT = 0;
		SCAN_CLASS_OBJECT = 0;
		SCAN_FLATTENED_ARRAY_OBJECT = 0;
		SCAN_INVALID_OBJECT = 0;
		SCAN_MIXED_OBJECT = 0;
		SCAN_MIXED_OBJECT_LINKED = 0;
		SCAN_OWNABLESYNCHRONIZER_OBJECT = 0;
		SCAN_POINTER_ARRAY_OBJECT = 0;
		SCAN_PRIMITIVE_ARRAY_OBJECT = 0;
		SCAN_REFERENCE_MIXED_OBJECT = 0;
	}

}
