/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: Cursor$DataType
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class Cursor$DataType {

	// VM Constants

	public static final long SIZEOF;
	public static final long BYTECODE;
	public static final long CLASS_FILE_SIZE;
	public static final long GENERIC;
	public static final long INTERMEDIATE_CLASS_DATA;
	public static final long INTERMEDIATE_CLASS_DATA_LENGTH;
	public static final long LINE_NUMBER_DATA;
	public static final long LOCAL_VARIABLE_COUNT;
	public static final long LOCAL_VARIABLE_DATA;
	public static final long LOCAL_VARIABLE_DATA_SRP_TO_UTF8;
	public static final long METHOD_DEBUG_SIZE;
	public static final long OPTINFO_SOURCE_FILE_NAME;
	public static final long OPTIONAL_FLAGS;
	public static final long ROM_CLASS_MODIFIERS;
	public static final long ROM_SIZE;
	public static final long SOURCE_DEBUG_EXT_DATA;
	public static final long SOURCE_DEBUG_EXT_LENGTH;
	public static final long SRP_TO_DEBUG_DATA;
	public static final long SRP_TO_GENERIC;
	public static final long SRP_TO_INTERMEDIATE_CLASS_DATA;
	public static final long SRP_TO_LOCAL_VARIABLE_DATA;
	public static final long SRP_TO_NAME_AND_SIGNATURE;
	public static final long SRP_TO_SOURCE_DEBUG_EXT;
	public static final long SRP_TO_UTF8;
	public static final long SRP_TO_UTF8_CLASS_NAME;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		BYTECODE = 0;
		CLASS_FILE_SIZE = 0;
		GENERIC = 0;
		INTERMEDIATE_CLASS_DATA = 0;
		INTERMEDIATE_CLASS_DATA_LENGTH = 0;
		LINE_NUMBER_DATA = 0;
		LOCAL_VARIABLE_COUNT = 0;
		LOCAL_VARIABLE_DATA = 0;
		LOCAL_VARIABLE_DATA_SRP_TO_UTF8 = 0;
		METHOD_DEBUG_SIZE = 0;
		OPTINFO_SOURCE_FILE_NAME = 0;
		OPTIONAL_FLAGS = 0;
		ROM_CLASS_MODIFIERS = 0;
		ROM_SIZE = 0;
		SOURCE_DEBUG_EXT_DATA = 0;
		SOURCE_DEBUG_EXT_LENGTH = 0;
		SRP_TO_DEBUG_DATA = 0;
		SRP_TO_GENERIC = 0;
		SRP_TO_INTERMEDIATE_CLASS_DATA = 0;
		SRP_TO_LOCAL_VARIABLE_DATA = 0;
		SRP_TO_NAME_AND_SIGNATURE = 0;
		SRP_TO_SOURCE_DEBUG_EXT = 0;
		SRP_TO_UTF8 = 0;
		SRP_TO_UTF8_CLASS_NAME = 0;
	}

}
