/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: CompositeCacheImplConstants
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class CompositeCacheImplConstants {

	// VM Constants

	public static final long SIZEOF;
	public static final long CC_MIN_SPACE_BEFORE_CACHE_FULL;
	public static final long CC_STARTUP_CORRUPT;
	public static final long CC_STARTUP_FAILED;
	public static final long CC_STARTUP_NO_CACHE;
	public static final long CC_STARTUP_OK;
	public static final long CC_STARTUP_RESET;
	public static final long CC_STARTUP_SOFT_RESET;
	public static final long J9SHR_CRC_MAX_SAMPLES;
	public static final long J9SHR_DUMMY_DATA_BYTE;
	public static final long J9SHR_MIN_GAP_BEFORE_METADATA;
	public static final long MANAGER_HPP_INCLUDED;
	public static final long MANAGER_HPP_INCLUDED_DEFINED;
	public static final long MAX_CC_SIZE;
	public static final long MIN_CC_SIZE;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		CC_MIN_SPACE_BEFORE_CACHE_FULL = 0;
		CC_STARTUP_CORRUPT = 0;
		CC_STARTUP_FAILED = 0;
		CC_STARTUP_NO_CACHE = 0;
		CC_STARTUP_OK = 0;
		CC_STARTUP_RESET = 0;
		CC_STARTUP_SOFT_RESET = 0;
		J9SHR_CRC_MAX_SAMPLES = 0;
		J9SHR_DUMMY_DATA_BYTE = 0;
		J9SHR_MIN_GAP_BEFORE_METADATA = 0;
		MANAGER_HPP_INCLUDED = 0;
		MANAGER_HPP_INCLUDED_DEFINED = 0;
		MAX_CC_SIZE = 0;
		MIN_CC_SIZE = 0;
	}

}
