/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: ClassFileOracle
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class ClassFileOracle {

	// VM Constants

	public static final long SIZEOF;
	public static final long CONTENDED_ANNOTATION;
	public static final long FRAMEITERATORSKIP_ANNOTATION;
	public static final long JAVA8_CONTENDED_ANNOTATION;
	public static final long JDK_INTERNAL_REFLECT_CALLERSENSITIVE_ANNOTATION;
	public static final long KNOWN_ANNOTATION_COUNT;
	public static final long SUN_REFLECT_CALLERSENSITIVE_ANNOTATION;
	public static final long UNMODIFIABLE_ANNOTATION;
	public static final long VALUEBASED_ANNOTATION;

	// Offsets

	public static final int __annotationRefersDoubleSlotEntryOffset_;
	public static final int __annotationsAttributeOffset_;
	public static final int __bctFlagsOffset_;
	public static final int __bootstrapMethodsAttributeOffset_;
	public static final int __bufferManagerOffset_;
	public static final int __buildResultOffset_;
	public static final int __classFileOffset_;
	public static final int __constantPoolMapOffset_;
	public static final int __contextOffset_;
	public static final int __doubleScalarStaticCountOffset_;
	public static final int __enclosingMethodOffset_;
	public static final int __fieldsInfoOffset_;
	public static final int __genericSignatureOffset_;
	public static final int __hasClinitOffset_;
	public static final int __hasEmptyFinalizeMethodOffset_;
	public static final int __hasFinalFieldsOffset_;
	public static final int __hasFinalizeMethodOffset_;
	public static final int __hasFrameIteratorSkipAnnotationOffset_;
	public static final int __hasNonStaticNonAbstractMethodsOffset_;
	public static final int __hasVerifyExcludeAttributeOffset_;
	public static final int __innerClassCountOffset_;
	public static final int __innerClassesOffset_;
	public static final int __isClassContendedOffset_;
	public static final int __isClassUnmodifiableOffset_;
	public static final int __isClassValueBasedOffset_;
	public static final int __isCloneableOffset_;
	public static final int __isInnerClassOffset_;
	public static final int __isRecordOffset_;
	public static final int __isSealedOffset_;
	public static final int __isSerializableOffset_;
	public static final int __isSyntheticOffset_;
	public static final int __maxBranchCountOffset_;
	public static final int __memberAccessFlagsOffset_;
	public static final int __methodsInfoOffset_;
	public static final int __needsStaticConstantInitOffset_;
	public static final int __nestHostOffset_;
	public static final int __nestMembersOffset_;
	public static final int __nestMembersCountOffset_;
	public static final int __objectStaticCountOffset_;
	public static final int __outerClassNameIndexOffset_;
	public static final int __permittedSubclassesAttributeOffset_;
	public static final int __recordComponentCountOffset_;
	public static final int __recordComponentsInfoOffset_;
	public static final int __romBuilderClassFileBufferOffset_;
	public static final int __simpleNameIndexOffset_;
	public static final int __singleScalarStaticCountOffset_;
	public static final int __sourceDebugExtensionOffset_;
	public static final int __sourceFileOffset_;
	public static final int __typeAnnotationsAttributeOffset_;
	public static final int __verifyExcludeAttributeOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		CONTENDED_ANNOTATION = 0;
		FRAMEITERATORSKIP_ANNOTATION = 0;
		JAVA8_CONTENDED_ANNOTATION = 0;
		JDK_INTERNAL_REFLECT_CALLERSENSITIVE_ANNOTATION = 0;
		KNOWN_ANNOTATION_COUNT = 0;
		SUN_REFLECT_CALLERSENSITIVE_ANNOTATION = 0;
		UNMODIFIABLE_ANNOTATION = 0;
		VALUEBASED_ANNOTATION = 0;
		__annotationRefersDoubleSlotEntryOffset_ = 0;
		__annotationsAttributeOffset_ = 0;
		__bctFlagsOffset_ = 0;
		__bootstrapMethodsAttributeOffset_ = 0;
		__bufferManagerOffset_ = 0;
		__buildResultOffset_ = 0;
		__classFileOffset_ = 0;
		__constantPoolMapOffset_ = 0;
		__contextOffset_ = 0;
		__doubleScalarStaticCountOffset_ = 0;
		__enclosingMethodOffset_ = 0;
		__fieldsInfoOffset_ = 0;
		__genericSignatureOffset_ = 0;
		__hasClinitOffset_ = 0;
		__hasEmptyFinalizeMethodOffset_ = 0;
		__hasFinalFieldsOffset_ = 0;
		__hasFinalizeMethodOffset_ = 0;
		__hasFrameIteratorSkipAnnotationOffset_ = 0;
		__hasNonStaticNonAbstractMethodsOffset_ = 0;
		__hasVerifyExcludeAttributeOffset_ = 0;
		__innerClassCountOffset_ = 0;
		__innerClassesOffset_ = 0;
		__isClassContendedOffset_ = 0;
		__isClassUnmodifiableOffset_ = 0;
		__isClassValueBasedOffset_ = 0;
		__isCloneableOffset_ = 0;
		__isInnerClassOffset_ = 0;
		__isRecordOffset_ = 0;
		__isSealedOffset_ = 0;
		__isSerializableOffset_ = 0;
		__isSyntheticOffset_ = 0;
		__maxBranchCountOffset_ = 0;
		__memberAccessFlagsOffset_ = 0;
		__methodsInfoOffset_ = 0;
		__needsStaticConstantInitOffset_ = 0;
		__nestHostOffset_ = 0;
		__nestMembersOffset_ = 0;
		__nestMembersCountOffset_ = 0;
		__objectStaticCountOffset_ = 0;
		__outerClassNameIndexOffset_ = 0;
		__permittedSubclassesAttributeOffset_ = 0;
		__recordComponentCountOffset_ = 0;
		__recordComponentsInfoOffset_ = 0;
		__romBuilderClassFileBufferOffset_ = 0;
		__simpleNameIndexOffset_ = 0;
		__singleScalarStaticCountOffset_ = 0;
		__sourceDebugExtensionOffset_ = 0;
		__sourceFileOffset_ = 0;
		__typeAnnotationsAttributeOffset_ = 0;
		__verifyExcludeAttributeOffset_ = 0;
	}

}
