/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 *  SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/

/**
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: unixthread_attrPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the unixthread_attrPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=unixthread_attr.class)
public class unixthread_attrPointer extends StructurePointer {

	// NULL
	public static final unixthread_attrPointer NULL = new unixthread_attrPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected unixthread_attrPointer(long address) {
		super(address);
	}

	public static unixthread_attrPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static unixthread_attrPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static unixthread_attrPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}

		return new unixthread_attrPointer(address);
	}

	public unixthread_attrPointer add(long count) {
		return unixthread_attrPointer.cast(address + (unixthread_attr.SIZEOF * count));
	}

	public unixthread_attrPointer add(Scalar count) {
		return add(count.longValue());
	}

	public unixthread_attrPointer addOffset(long offset) {
		return unixthread_attrPointer.cast(address + offset);
	}

	public unixthread_attrPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public unixthread_attrPointer sub(long count) {
		return unixthread_attrPointer.cast(address - (unixthread_attr.SIZEOF * count));
	}

	public unixthread_attrPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public unixthread_attrPointer subOffset(long offset) {
		return unixthread_attrPointer.cast(address - offset);
	}

	public unixthread_attrPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public unixthread_attrPointer untag(long mask) {
		return unixthread_attrPointer.cast(address & ~mask);
	}

	public unixthread_attrPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return unixthread_attr.SIZEOF;
	}

	// Implementation methods

	// omrthread_attr hdr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hdrOffset_", declaredType="omrthread_attr")
	public omrthread_attrPointer hdr() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return omrthread_attrPointer.cast(address + unixthread_attr._hdrOffset_);
	}

	// omrthread_attr hdr
	public PointerPointer hdrEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + unixthread_attr._hdrOffset_);
	}

	// pthread_attr_t pattr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pattrOffset_", declaredType="pthread_attr_t")
	public _opaque_pthread_attr_tPointer pattr() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return _opaque_pthread_attr_tPointer.cast(address + unixthread_attr._pattrOffset_);
	}

	// pthread_attr_t pattr
	public PointerPointer pattrEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + unixthread_attr._pattrOffset_);
	}

}
