/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 *  SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/

/**
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: jvmtiMonitorUsagePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the jvmtiMonitorUsagePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=jvmtiMonitorUsage.class)
public class jvmtiMonitorUsagePointer extends StructurePointer {

	// NULL
	public static final jvmtiMonitorUsagePointer NULL = new jvmtiMonitorUsagePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected jvmtiMonitorUsagePointer(long address) {
		super(address);
	}

	public static jvmtiMonitorUsagePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static jvmtiMonitorUsagePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static jvmtiMonitorUsagePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}

		return new jvmtiMonitorUsagePointer(address);
	}

	public jvmtiMonitorUsagePointer add(long count) {
		return jvmtiMonitorUsagePointer.cast(address + (jvmtiMonitorUsage.SIZEOF * count));
	}

	public jvmtiMonitorUsagePointer add(Scalar count) {
		return add(count.longValue());
	}

	public jvmtiMonitorUsagePointer addOffset(long offset) {
		return jvmtiMonitorUsagePointer.cast(address + offset);
	}

	public jvmtiMonitorUsagePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public jvmtiMonitorUsagePointer sub(long count) {
		return jvmtiMonitorUsagePointer.cast(address - (jvmtiMonitorUsage.SIZEOF * count));
	}

	public jvmtiMonitorUsagePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public jvmtiMonitorUsagePointer subOffset(long offset) {
		return jvmtiMonitorUsagePointer.cast(address - offset);
	}

	public jvmtiMonitorUsagePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public jvmtiMonitorUsagePointer untag(long mask) {
		return jvmtiMonitorUsagePointer.cast(address & ~mask);
	}

	public jvmtiMonitorUsagePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return jvmtiMonitorUsage.SIZEOF;
	}

	// Implementation methods

	// jint entry_count
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_entry_countOffset_", declaredType="jint")
	public IDATA entry_count() throws CorruptDataException {
		return new I32(getIntAtOffset(jvmtiMonitorUsage._entry_countOffset_));
	}

	// jint entry_count
	public IDATAPointer entry_countEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return IDATAPointer.cast(address + jvmtiMonitorUsage._entry_countOffset_);
	}

	// jint notify_waiter_count
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_notify_waiter_countOffset_", declaredType="jint")
	public IDATA notify_waiter_count() throws CorruptDataException {
		return new I32(getIntAtOffset(jvmtiMonitorUsage._notify_waiter_countOffset_));
	}

	// jint notify_waiter_count
	public IDATAPointer notify_waiter_countEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return IDATAPointer.cast(address + jvmtiMonitorUsage._notify_waiter_countOffset_);
	}

	// jthread* notify_waiters
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_notify_waitersOffset_", declaredType="jthread*")
	public PointerPointer notify_waiters() throws CorruptDataException {
		return PointerPointer.cast(getPointerAtOffset(jvmtiMonitorUsage._notify_waitersOffset_));
	}

	// jthread* notify_waiters
	public PointerPointer notify_waitersEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + jvmtiMonitorUsage._notify_waitersOffset_);
	}

	// jthread owner
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ownerOffset_", declaredType="jthread")
	public _jobjectPointer owner() throws CorruptDataException {
		long pointer = getPointerAtOffset(jvmtiMonitorUsage._ownerOffset_);
		return _jobjectPointer.cast(pointer);
	}

	// jthread owner
	public PointerPointer ownerEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + jvmtiMonitorUsage._ownerOffset_);
	}

	// jint waiter_count
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_waiter_countOffset_", declaredType="jint")
	public IDATA waiter_count() throws CorruptDataException {
		return new I32(getIntAtOffset(jvmtiMonitorUsage._waiter_countOffset_));
	}

	// jint waiter_count
	public IDATAPointer waiter_countEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return IDATAPointer.cast(address + jvmtiMonitorUsage._waiter_countOffset_);
	}

	// jthread* waiters
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_waitersOffset_", declaredType="jthread*")
	public PointerPointer waiters() throws CorruptDataException {
		return PointerPointer.cast(getPointerAtOffset(jvmtiMonitorUsage._waitersOffset_));
	}

	// jthread* waiters
	public PointerPointer waitersEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + jvmtiMonitorUsage._waitersOffset_);
	}

}
