/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 *  SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/

/**
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: UtProcInfoPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the UtProcInfoPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=UtProcInfo.class)
public class UtProcInfoPointer extends StructurePointer {

	// NULL
	public static final UtProcInfoPointer NULL = new UtProcInfoPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected UtProcInfoPointer(long address) {
		super(address);
	}

	public static UtProcInfoPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static UtProcInfoPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static UtProcInfoPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}

		return new UtProcInfoPointer(address);
	}

	public UtProcInfoPointer add(long count) {
		return UtProcInfoPointer.cast(address + (UtProcInfo.SIZEOF * count));
	}

	public UtProcInfoPointer add(Scalar count) {
		return add(count.longValue());
	}

	public UtProcInfoPointer addOffset(long offset) {
		return UtProcInfoPointer.cast(address + offset);
	}

	public UtProcInfoPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public UtProcInfoPointer sub(long count) {
		return UtProcInfoPointer.cast(address - (UtProcInfo.SIZEOF * count));
	}

	public UtProcInfoPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public UtProcInfoPointer subOffset(long offset) {
		return UtProcInfoPointer.cast(address - offset);
	}

	public UtProcInfoPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public UtProcInfoPointer untag(long mask) {
		return UtProcInfoPointer.cast(address & ~mask);
	}

	public UtProcInfoPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return UtProcInfo.SIZEOF;
	}

	// Implementation methods

	// UtDataHeader header
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_headerOffset_", declaredType="UtDataHeader")
	public UtDataHeaderPointer header() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UtDataHeaderPointer.cast(address + UtProcInfo._headerOffset_);
	}

	// UtDataHeader header
	public PointerPointer headerEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + UtProcInfo._headerOffset_);
	}

	// UtSubtype subtype
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_subtypeOffset_", declaredType="UtSubtype")
	public long subtype() throws CorruptDataException {
			if (UtSubtype.SIZEOF == 1) {
				return getByteAtOffset(UtProcInfo._subtypeOffset_);
			} else if (UtSubtype.SIZEOF == 2) {
				return getShortAtOffset(UtProcInfo._subtypeOffset_);
			} else if (UtSubtype.SIZEOF == 4) {
				return getIntAtOffset(UtProcInfo._subtypeOffset_);
			} else if (UtSubtype.SIZEOF == 8) {
				return getLongAtOffset(UtProcInfo._subtypeOffset_);
			} else {
				throw new IllegalArgumentException("Unexpected ENUM size in core file");
			}
	}

	// UtSubtype subtype
	public EnumPointer subtypeEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return EnumPointer.cast(address + UtProcInfo._subtypeOffset_, UtSubtype.class);
	}

	// UtTraceCounter traceCounter
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_traceCounterOffset_", declaredType="UtTraceCounter")
	public long traceCounter() throws CorruptDataException {
			if (UtTraceCounter.SIZEOF == 1) {
				return getByteAtOffset(UtProcInfo._traceCounterOffset_);
			} else if (UtTraceCounter.SIZEOF == 2) {
				return getShortAtOffset(UtProcInfo._traceCounterOffset_);
			} else if (UtTraceCounter.SIZEOF == 4) {
				return getIntAtOffset(UtProcInfo._traceCounterOffset_);
			} else if (UtTraceCounter.SIZEOF == 8) {
				return getLongAtOffset(UtProcInfo._traceCounterOffset_);
			} else {
				throw new IllegalArgumentException("Unexpected ENUM size in core file");
			}
	}

	// UtTraceCounter traceCounter
	public EnumPointer traceCounterEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return EnumPointer.cast(address + UtProcInfo._traceCounterOffset_, UtTraceCounter.class);
	}

}
