/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 *  SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/

/**
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: MethodNotesPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the MethodNotesPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=MethodNotes.class)
public class MethodNotesPointer extends StructurePointer {

	// NULL
	public static final MethodNotesPointer NULL = new MethodNotesPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected MethodNotesPointer(long address) {
		super(address);
	}

	public static MethodNotesPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static MethodNotesPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static MethodNotesPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}

		return new MethodNotesPointer(address);
	}

	public MethodNotesPointer add(long count) {
		return MethodNotesPointer.cast(address + (MethodNotes.SIZEOF * count));
	}

	public MethodNotesPointer add(Scalar count) {
		return add(count.longValue());
	}

	public MethodNotesPointer addOffset(long offset) {
		return MethodNotesPointer.cast(address + offset);
	}

	public MethodNotesPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public MethodNotesPointer sub(long count) {
		return MethodNotesPointer.cast(address - (MethodNotes.SIZEOF * count));
	}

	public MethodNotesPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public MethodNotesPointer subOffset(long offset) {
		return MethodNotesPointer.cast(address - offset);
	}

	public MethodNotesPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public MethodNotesPointer untag(long mask) {
		return MethodNotesPointer.cast(address & ~mask);
	}

	public MethodNotesPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return MethodNotes.SIZEOF;
	}

	// Implementation methods

	// U32 debugInfoSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_debugInfoSizeOffset_", declaredType="U32")
	public UDATA debugInfoSize() throws CorruptDataException {
		return new U32(getIntAtOffset(MethodNotes._debugInfoSizeOffset_));
	}

	// U32 debugInfoSize
	public UDATAPointer debugInfoSizeEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + MethodNotes._debugInfoSizeOffset_);
	}

	// U32 stackMapSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_stackMapSizeOffset_", declaredType="U32")
	public UDATA stackMapSize() throws CorruptDataException {
		return new U32(getIntAtOffset(MethodNotes._stackMapSizeOffset_));
	}

	// U32 stackMapSize
	public UDATAPointer stackMapSizeEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + MethodNotes._stackMapSizeOffset_);
	}

}
