/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 *  SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/

/**
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: MM_VerboseWriterFileLoggingPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the MM_VerboseWriterFileLoggingPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=MM_VerboseWriterFileLogging.class)
public class MM_VerboseWriterFileLoggingPointer extends MM_VerboseWriterPointer {

	// NULL
	public static final MM_VerboseWriterFileLoggingPointer NULL = new MM_VerboseWriterFileLoggingPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected MM_VerboseWriterFileLoggingPointer(long address) {
		super(address);
	}

	public static MM_VerboseWriterFileLoggingPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static MM_VerboseWriterFileLoggingPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static MM_VerboseWriterFileLoggingPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}

		return new MM_VerboseWriterFileLoggingPointer(address);
	}

	public MM_VerboseWriterFileLoggingPointer add(long count) {
		return MM_VerboseWriterFileLoggingPointer.cast(address + (MM_VerboseWriterFileLogging.SIZEOF * count));
	}

	public MM_VerboseWriterFileLoggingPointer add(Scalar count) {
		return add(count.longValue());
	}

	public MM_VerboseWriterFileLoggingPointer addOffset(long offset) {
		return MM_VerboseWriterFileLoggingPointer.cast(address + offset);
	}

	public MM_VerboseWriterFileLoggingPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public MM_VerboseWriterFileLoggingPointer sub(long count) {
		return MM_VerboseWriterFileLoggingPointer.cast(address - (MM_VerboseWriterFileLogging.SIZEOF * count));
	}

	public MM_VerboseWriterFileLoggingPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public MM_VerboseWriterFileLoggingPointer subOffset(long offset) {
		return MM_VerboseWriterFileLoggingPointer.cast(address - offset);
	}

	public MM_VerboseWriterFileLoggingPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public MM_VerboseWriterFileLoggingPointer untag(long mask) {
		return MM_VerboseWriterFileLoggingPointer.cast(address & ~mask);
	}

	public MM_VerboseWriterFileLoggingPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return MM_VerboseWriterFileLogging.SIZEOF;
	}

	// Implementation methods

	// U64 _currentCycle
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__currentCycleOffset_", declaredType="U64")
	public UDATA _currentCycle() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_VerboseWriterFileLogging.__currentCycleOffset_));
	}

	// U64 _currentCycle
	public UDATAPointer _currentCycleEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + MM_VerboseWriterFileLogging.__currentCycleOffset_);
	}

	// U64 _currentFile
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__currentFileOffset_", declaredType="U64")
	public UDATA _currentFile() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_VerboseWriterFileLogging.__currentFileOffset_));
	}

	// U64 _currentFile
	public UDATAPointer _currentFileEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + MM_VerboseWriterFileLogging.__currentFileOffset_);
	}

	// U8* _filename
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__filenameOffset_", declaredType="U8*")
	public U8Pointer _filename() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(MM_VerboseWriterFileLogging.__filenameOffset_));
	}

	// U8* _filename
	public PointerPointer _filenameEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + MM_VerboseWriterFileLogging.__filenameOffset_);
	}

	// MM_VerboseManager* _manager
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__managerOffset_", declaredType="MM_VerboseManager*")
	public MM_VerboseManagerPointer _manager() throws CorruptDataException {
		long pointer = getPointerAtOffset(MM_VerboseWriterFileLogging.__managerOffset_);
		return MM_VerboseManagerPointer.cast(pointer);
	}

	// MM_VerboseManager* _manager
	public PointerPointer _managerEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + MM_VerboseWriterFileLogging.__managerOffset_);
	}

	// U64 _mode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__modeOffset_", declaredType="U64")
	public UDATA _mode() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_VerboseWriterFileLogging.__modeOffset_));
	}

	// U64 _mode
	public UDATAPointer _modeEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + MM_VerboseWriterFileLogging.__modeOffset_);
	}

	// U64 _numCycles
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__numCyclesOffset_", declaredType="U64")
	public UDATA _numCycles() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_VerboseWriterFileLogging.__numCyclesOffset_));
	}

	// U64 _numCycles
	public UDATAPointer _numCyclesEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + MM_VerboseWriterFileLogging.__numCyclesOffset_);
	}

	// U64 _numFiles
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__numFilesOffset_", declaredType="U64")
	public UDATA _numFiles() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_VerboseWriterFileLogging.__numFilesOffset_));
	}

	// U64 _numFiles
	public UDATAPointer _numFilesEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + MM_VerboseWriterFileLogging.__numFilesOffset_);
	}

	// J9StringTokens* _tokens
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__tokensOffset_", declaredType="J9StringTokens*")
	public J9StringTokensPointer _tokens() throws CorruptDataException {
		long pointer = getPointerAtOffset(MM_VerboseWriterFileLogging.__tokensOffset_);
		return J9StringTokensPointer.cast(pointer);
	}

	// J9StringTokens* _tokens
	public PointerPointer _tokensEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + MM_VerboseWriterFileLogging.__tokensOffset_);
	}

}
