/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 *  SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/

/**
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9VMLoadJNILibraryEventPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9VMLoadJNILibraryEventPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9VMLoadJNILibraryEvent.class)
public class J9VMLoadJNILibraryEventPointer extends StructurePointer {

	// NULL
	public static final J9VMLoadJNILibraryEventPointer NULL = new J9VMLoadJNILibraryEventPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9VMLoadJNILibraryEventPointer(long address) {
		super(address);
	}

	public static J9VMLoadJNILibraryEventPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9VMLoadJNILibraryEventPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9VMLoadJNILibraryEventPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}

		return new J9VMLoadJNILibraryEventPointer(address);
	}

	public J9VMLoadJNILibraryEventPointer add(long count) {
		return J9VMLoadJNILibraryEventPointer.cast(address + (J9VMLoadJNILibraryEvent.SIZEOF * count));
	}

	public J9VMLoadJNILibraryEventPointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9VMLoadJNILibraryEventPointer addOffset(long offset) {
		return J9VMLoadJNILibraryEventPointer.cast(address + offset);
	}

	public J9VMLoadJNILibraryEventPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9VMLoadJNILibraryEventPointer sub(long count) {
		return J9VMLoadJNILibraryEventPointer.cast(address - (J9VMLoadJNILibraryEvent.SIZEOF * count));
	}

	public J9VMLoadJNILibraryEventPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9VMLoadJNILibraryEventPointer subOffset(long offset) {
		return J9VMLoadJNILibraryEventPointer.cast(address - offset);
	}

	public J9VMLoadJNILibraryEventPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9VMLoadJNILibraryEventPointer untag(long mask) {
		return J9VMLoadJNILibraryEventPointer.cast(address & ~mask);
	}

	public J9VMLoadJNILibraryEventPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9VMLoadJNILibraryEvent.SIZEOF;
	}

	// Implementation methods

	// UDATA bufLen
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_bufLenOffset_", declaredType="UDATA")
	public UDATA bufLen() throws CorruptDataException {
		return new UDATA(getUDATAAtOffset(J9VMLoadJNILibraryEvent._bufLenOffset_));
	}

	// UDATA bufLen
	public UDATAPointer bufLenEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + J9VMLoadJNILibraryEvent._bufLenOffset_);
	}

	// J9ClassLoader* classLoader
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_classLoaderOffset_", declaredType="J9ClassLoader*")
	public J9ClassLoaderPointer classLoader() throws CorruptDataException {
		long pointer = getPointerAtOffset(J9VMLoadJNILibraryEvent._classLoaderOffset_);
		return J9ClassLoaderPointer.cast(pointer);
	}

	// J9ClassLoader* classLoader
	public PointerPointer classLoaderEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9VMLoadJNILibraryEvent._classLoaderOffset_);
	}

	// J9VMThread* currentThread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_currentThreadOffset_", declaredType="J9VMThread*")
	public J9VMThreadPointer currentThread() throws CorruptDataException {
		long pointer = getPointerAtOffset(J9VMLoadJNILibraryEvent._currentThreadOffset_);
		return J9VMThreadPointer.cast(pointer);
	}

	// J9VMThread* currentThread
	public PointerPointer currentThreadEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9VMLoadJNILibraryEvent._currentThreadOffset_);
	}

	// U8* errorBuf
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_errorBufOffset_", declaredType="U8*")
	public U8Pointer errorBuf() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(J9VMLoadJNILibraryEvent._errorBufOffset_));
	}

	// U8* errorBuf
	public PointerPointer errorBufEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9VMLoadJNILibraryEvent._errorBufOffset_);
	}

	// U8* logicalName
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_logicalNameOffset_", declaredType="U8*")
	public U8Pointer logicalName() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(J9VMLoadJNILibraryEvent._logicalNameOffset_));
	}

	// U8* logicalName
	public PointerPointer logicalNameEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9VMLoadJNILibraryEvent._logicalNameOffset_);
	}

	// J9NativeLibrary* nativeLibrary
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nativeLibraryOffset_", declaredType="J9NativeLibrary*")
	public J9NativeLibraryPointer nativeLibrary() throws CorruptDataException {
		long pointer = getPointerAtOffset(J9VMLoadJNILibraryEvent._nativeLibraryOffset_);
		return J9NativeLibraryPointer.cast(pointer);
	}

	// J9NativeLibrary* nativeLibrary
	public PointerPointer nativeLibraryEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9VMLoadJNILibraryEvent._nativeLibraryOffset_);
	}

	// UDATA openFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_openFlagsOffset_", declaredType="UDATA")
	public UDATA openFlags() throws CorruptDataException {
		return new UDATA(getUDATAAtOffset(J9VMLoadJNILibraryEvent._openFlagsOffset_));
	}

	// UDATA openFlags
	public UDATAPointer openFlagsEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + J9VMLoadJNILibraryEvent._openFlagsOffset_);
	}

	// UDATA result
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_resultOffset_", declaredType="UDATA")
	public UDATA result() throws CorruptDataException {
		return new UDATA(getUDATAAtOffset(J9VMLoadJNILibraryEvent._resultOffset_));
	}

	// UDATA result
	public UDATAPointer resultEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + J9VMLoadJNILibraryEvent._resultOffset_);
	}

}
