/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 *  SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/

/**
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9MemorySegmentPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9MemorySegmentPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9MemorySegment.class)
public class J9MemorySegmentPointer extends StructurePointer {

	// NULL
	public static final J9MemorySegmentPointer NULL = new J9MemorySegmentPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9MemorySegmentPointer(long address) {
		super(address);
	}

	public static J9MemorySegmentPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9MemorySegmentPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9MemorySegmentPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}

		return new J9MemorySegmentPointer(address);
	}

	public J9MemorySegmentPointer add(long count) {
		return J9MemorySegmentPointer.cast(address + (J9MemorySegment.SIZEOF * count));
	}

	public J9MemorySegmentPointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9MemorySegmentPointer addOffset(long offset) {
		return J9MemorySegmentPointer.cast(address + offset);
	}

	public J9MemorySegmentPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9MemorySegmentPointer sub(long count) {
		return J9MemorySegmentPointer.cast(address - (J9MemorySegment.SIZEOF * count));
	}

	public J9MemorySegmentPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9MemorySegmentPointer subOffset(long offset) {
		return J9MemorySegmentPointer.cast(address - offset);
	}

	public J9MemorySegmentPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9MemorySegmentPointer untag(long mask) {
		return J9MemorySegmentPointer.cast(address & ~mask);
	}

	public J9MemorySegmentPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9MemorySegment.SIZEOF;
	}

	// Implementation methods

	// U8* baseAddress
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_baseAddressOffset_", declaredType="U8*")
	public U8Pointer baseAddress() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(J9MemorySegment._baseAddressOffset_));
	}

	// U8* baseAddress
	public PointerPointer baseAddressEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9MemorySegment._baseAddressOffset_);
	}

	// J9ClassLoader* classLoader
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_classLoaderOffset_", declaredType="J9ClassLoader*")
	public J9ClassLoaderPointer classLoader() throws CorruptDataException {
		long pointer = getPointerAtOffset(J9MemorySegment._classLoaderOffset_);
		return J9ClassLoaderPointer.cast(pointer);
	}

	// J9ClassLoader* classLoader
	public PointerPointer classLoaderEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9MemorySegment._classLoaderOffset_);
	}

	// U8* heapAlloc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_heapAllocOffset_", declaredType="U8*")
	public U8Pointer heapAlloc() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(J9MemorySegment._heapAllocOffset_));
	}

	// U8* heapAlloc
	public PointerPointer heapAllocEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9MemorySegment._heapAllocOffset_);
	}

	// U8* heapBase
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_heapBaseOffset_", declaredType="U8*")
	public U8Pointer heapBase() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(J9MemorySegment._heapBaseOffset_));
	}

	// U8* heapBase
	public PointerPointer heapBaseEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9MemorySegment._heapBaseOffset_);
	}

	// U8* heapTop
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_heapTopOffset_", declaredType="U8*")
	public U8Pointer heapTop() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(J9MemorySegment._heapTopOffset_));
	}

	// U8* heapTop
	public PointerPointer heapTopEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9MemorySegment._heapTopOffset_);
	}

	// J9MemorySegmentList* memorySegmentList
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_memorySegmentListOffset_", declaredType="J9MemorySegmentList*")
	public J9MemorySegmentListPointer memorySegmentList() throws CorruptDataException {
		long pointer = getPointerAtOffset(J9MemorySegment._memorySegmentListOffset_);
		return J9MemorySegmentListPointer.cast(pointer);
	}

	// J9MemorySegmentList* memorySegmentList
	public PointerPointer memorySegmentListEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9MemorySegment._memorySegmentListOffset_);
	}

	// void* memorySpace
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_memorySpaceOffset_", declaredType="void*")
	public VoidPointer memorySpace() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9MemorySegment._memorySpaceOffset_));
	}

	// void* memorySpace
	public PointerPointer memorySpaceEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9MemorySegment._memorySpaceOffset_);
	}

	// J9MemorySegment* nextSegment
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nextSegmentOffset_", declaredType="J9MemorySegment*")
	public J9MemorySegmentPointer nextSegment() throws CorruptDataException {
		long pointer = getPointerAtOffset(J9MemorySegment._nextSegmentOffset_);
		return J9MemorySegmentPointer.cast(pointer);
	}

	// J9MemorySegment* nextSegment
	public PointerPointer nextSegmentEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9MemorySegment._nextSegmentOffset_);
	}

	// J9MemorySegment* nextSegmentInClassLoader
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nextSegmentInClassLoaderOffset_", declaredType="J9MemorySegment*")
	public J9MemorySegmentPointer nextSegmentInClassLoader() throws CorruptDataException {
		long pointer = getPointerAtOffset(J9MemorySegment._nextSegmentInClassLoaderOffset_);
		return J9MemorySegmentPointer.cast(pointer);
	}

	// J9MemorySegment* nextSegmentInClassLoader
	public PointerPointer nextSegmentInClassLoaderEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9MemorySegment._nextSegmentInClassLoaderOffset_);
	}

	// J9AVLTreeNode parentAVLTreeNode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_parentAVLTreeNodeOffset_", declaredType="J9AVLTreeNode")
	public J9AVLTreeNodePointer parentAVLTreeNode() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return J9AVLTreeNodePointer.cast(address + J9MemorySegment._parentAVLTreeNodeOffset_);
	}

	// J9AVLTreeNode parentAVLTreeNode
	public PointerPointer parentAVLTreeNodeEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9MemorySegment._parentAVLTreeNodeOffset_);
	}

	// J9MemorySegment* previousSegment
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_previousSegmentOffset_", declaredType="J9MemorySegment*")
	public J9MemorySegmentPointer previousSegment() throws CorruptDataException {
		long pointer = getPointerAtOffset(J9MemorySegment._previousSegmentOffset_);
		return J9MemorySegmentPointer.cast(pointer);
	}

	// J9MemorySegment* previousSegment
	public PointerPointer previousSegmentEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9MemorySegment._previousSegmentOffset_);
	}

	// U64 size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sizeOffset_", declaredType="U64")
	public UDATA size() throws CorruptDataException {
		return new U64(getLongAtOffset(J9MemorySegment._sizeOffset_));
	}

	// U64 size
	public UDATAPointer sizeEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + J9MemorySegment._sizeOffset_);
	}

	// U64 type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_typeOffset_", declaredType="U64")
	public UDATA type() throws CorruptDataException {
		return new U64(getLongAtOffset(J9MemorySegment._typeOffset_));
	}

	// U64 type
	public UDATAPointer typeEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + J9MemorySegment._typeOffset_);
	}

	// U64 unused1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_unused1Offset_", declaredType="U64")
	public UDATA unused1() throws CorruptDataException {
		return new U64(getLongAtOffset(J9MemorySegment._unused1Offset_));
	}

	// U64 unused1
	public UDATAPointer unused1EA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + J9MemorySegment._unused1Offset_);
	}

	// J9PortVmemIdentifier vmemIdentifier
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vmemIdentifierOffset_", declaredType="J9PortVmemIdentifier")
	public J9PortVmemIdentifierPointer vmemIdentifier() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return J9PortVmemIdentifierPointer.cast(address + J9MemorySegment._vmemIdentifierOffset_);
	}

	// J9PortVmemIdentifier vmemIdentifier
	public PointerPointer vmemIdentifierEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9MemorySegment._vmemIdentifierOffset_);
	}

}
