/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 *  SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/

/**
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9FormatDataPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9FormatDataPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9FormatData.class)
public class J9FormatDataPointer extends StructurePointer {

	// NULL
	public static final J9FormatDataPointer NULL = new J9FormatDataPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9FormatDataPointer(long address) {
		super(address);
	}

	public static J9FormatDataPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9FormatDataPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9FormatDataPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}

		return new J9FormatDataPointer(address);
	}

	public J9FormatDataPointer add(long count) {
		return J9FormatDataPointer.cast(address + (J9FormatData.SIZEOF * count));
	}

	public J9FormatDataPointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9FormatDataPointer addOffset(long offset) {
		return J9FormatDataPointer.cast(address + offset);
	}

	public J9FormatDataPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9FormatDataPointer sub(long count) {
		return J9FormatDataPointer.cast(address - (J9FormatData.SIZEOF * count));
	}

	public J9FormatDataPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9FormatDataPointer subOffset(long offset) {
		return J9FormatDataPointer.cast(address - offset);
	}

	public J9FormatDataPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9FormatDataPointer untag(long mask) {
		return J9FormatDataPointer.cast(address & ~mask);
	}

	public J9FormatDataPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9FormatData.SIZEOF;
	}

	// Implementation methods

	// const U8* formatString
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_formatStringOffset_", declaredType="const U8*")
	public U8Pointer formatString() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(J9FormatData._formatStringOffset_));
	}

	// const U8* formatString
	public PointerPointer formatStringEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9FormatData._formatStringOffset_);
	}

	// U8 immediateCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_immediateCountOffset_", declaredType="U8")
	public U8 immediateCount() throws CorruptDataException {
		return new U8(getByteAtOffset(J9FormatData._immediateCountOffset_));
	}

	// U8 immediateCount
	public U8Pointer immediateCountEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return U8Pointer.cast(address + J9FormatData._immediateCountOffset_);
	}

	// J9FormatSpecifier[] spec
	public J9FormatSpecifierPointer specEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return J9FormatSpecifierPointer.cast(address + J9FormatData._specOffset_);
	}

	// U8 specCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_specCountOffset_", declaredType="U8")
	public U8 specCount() throws CorruptDataException {
		return new U8(getByteAtOffset(J9FormatData._specCountOffset_));
	}

	// U8 specCount
	public U8Pointer specCountEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return U8Pointer.cast(address + J9FormatData._specCountOffset_);
	}

	// J9FormatValue[] value
	public J9FormatValuePointer valueEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return J9FormatValuePointer.cast(address + J9FormatData._valueOffset_);
	}

	// U8 valueCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_valueCountOffset_", declaredType="U8")
	public U8 valueCount() throws CorruptDataException {
		return new U8(getByteAtOffset(J9FormatData._valueCountOffset_));
	}

	// U8 valueCount
	public U8Pointer valueCountEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return U8Pointer.cast(address + J9FormatData._valueCountOffset_);
	}

	// U8[] valueType
	public U8Pointer valueTypeEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return U8Pointer.cast(address + J9FormatData._valueTypeOffset_);
	}

}
