/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 *  SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/

/**
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: AttachedDataWrapperPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the AttachedDataWrapperPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=AttachedDataWrapper.class)
public class AttachedDataWrapperPointer extends StructurePointer {

	// NULL
	public static final AttachedDataWrapperPointer NULL = new AttachedDataWrapperPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected AttachedDataWrapperPointer(long address) {
		super(address);
	}

	public static AttachedDataWrapperPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static AttachedDataWrapperPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static AttachedDataWrapperPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}

		return new AttachedDataWrapperPointer(address);
	}

	public AttachedDataWrapperPointer add(long count) {
		return AttachedDataWrapperPointer.cast(address + (AttachedDataWrapper.SIZEOF * count));
	}

	public AttachedDataWrapperPointer add(Scalar count) {
		return add(count.longValue());
	}

	public AttachedDataWrapperPointer addOffset(long offset) {
		return AttachedDataWrapperPointer.cast(address + offset);
	}

	public AttachedDataWrapperPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public AttachedDataWrapperPointer sub(long count) {
		return AttachedDataWrapperPointer.cast(address - (AttachedDataWrapper.SIZEOF * count));
	}

	public AttachedDataWrapperPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public AttachedDataWrapperPointer subOffset(long offset) {
		return AttachedDataWrapperPointer.cast(address - offset);
	}

	public AttachedDataWrapperPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public AttachedDataWrapperPointer untag(long mask) {
		return AttachedDataWrapperPointer.cast(address & ~mask);
	}

	public AttachedDataWrapperPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return AttachedDataWrapper.SIZEOF;
	}

	// Implementation methods

	// J9ShrOffset cacheOffset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cacheOffsetOffset_", declaredType="J9ShrOffset")
	public J9ShrOffsetPointer cacheOffset() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return J9ShrOffsetPointer.cast(address + AttachedDataWrapper._cacheOffsetOffset_);
	}

	// J9ShrOffset cacheOffset
	public PointerPointer cacheOffsetEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + AttachedDataWrapper._cacheOffsetOffset_);
	}

	// I32 corrupt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_corruptOffset_", declaredType="I32")
	public IDATA corrupt() throws CorruptDataException {
		return new I32(getIntAtOffset(AttachedDataWrapper._corruptOffset_));
	}

	// I32 corrupt
	public IDATAPointer corruptEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return IDATAPointer.cast(address + AttachedDataWrapper._corruptOffset_);
	}

	// U32 dataLength
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dataLengthOffset_", declaredType="U32")
	public UDATA dataLength() throws CorruptDataException {
		return new U32(getIntAtOffset(AttachedDataWrapper._dataLengthOffset_));
	}

	// U32 dataLength
	public UDATAPointer dataLengthEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + AttachedDataWrapper._dataLengthOffset_);
	}

	// U16 type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_typeOffset_", declaredType="U16")
	public U16 type() throws CorruptDataException {
		return new U16(getShortAtOffset(AttachedDataWrapper._typeOffset_));
	}

	// U16 type
	public U16Pointer typeEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return U16Pointer.cast(address + AttachedDataWrapper._typeOffset_);
	}

	// U16 updateCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_updateCountOffset_", declaredType="U16")
	public U16 updateCount() throws CorruptDataException {
		return new U16(getShortAtOffset(AttachedDataWrapper._updateCountOffset_));
	}

	// U16 updateCount
	public U16Pointer updateCountEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return U16Pointer.cast(address + AttachedDataWrapper._updateCountOffset_);
	}

}
