/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.structure.Bucket;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

@GeneratedPointerClass(structureClass=Bucket.class)
public class BucketPointer
extends StructurePointer {
    public static final BucketPointer NULL = new BucketPointer(0L);

    protected BucketPointer(long address) {
        super(address);
    }

    public static BucketPointer cast(AbstractPointer structure) {
        return BucketPointer.cast(structure.getAddress());
    }

    public static BucketPointer cast(UDATA udata) {
        return BucketPointer.cast(udata.longValue());
    }

    public static BucketPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new BucketPointer(address);
    }

    @Override
    public BucketPointer add(long count) {
        return BucketPointer.cast(this.address + Bucket.SIZEOF * count);
    }

    @Override
    public BucketPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public BucketPointer addOffset(long offset) {
        return BucketPointer.cast(this.address + offset);
    }

    @Override
    public BucketPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public BucketPointer sub(long count) {
        return BucketPointer.cast(this.address - Bucket.SIZEOF * count);
    }

    @Override
    public BucketPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public BucketPointer subOffset(long offset) {
        return BucketPointer.cast(this.address - offset);
    }

    @Override
    public BucketPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public BucketPointer untag(long mask) {
        return BucketPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public BucketPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return Bucket.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_cardCountOffset_", declaredType="UDATA")
    public UDATA cardCount() throws CorruptDataException {
        return new UDATA(this.getUDATAAtOffset(Bucket._cardCountOffset_));
    }

    public UDATAPointer cardCountEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)Bucket._cardCountOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_duplicatesOffset_", declaredType="UDATA")
    public UDATA duplicates() throws CorruptDataException {
        return new UDATA(this.getUDATAAtOffset(Bucket._duplicatesOffset_));
    }

    public UDATAPointer duplicatesEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)Bucket._duplicatesOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_regionCountOffset_", declaredType="UDATA")
    public UDATA regionCount() throws CorruptDataException {
        return new UDATA(this.getUDATAAtOffset(Bucket._regionCountOffset_));
    }

    public UDATAPointer regionCountEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)Bucket._regionCountOffset_);
    }
}

