/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.view.dtfj.java;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.JavaLocation;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.java.JavaStackFrame;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.vm29.j9.OptInfo;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.types.UDATA;
import com.ibm.j9ddr.vm29.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaMethod;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaThread;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DTFJJavaStackFrame
implements JavaStackFrame,
JavaLocation {
    private final ImagePointer basePointer;
    private final DTFJJavaMethod dtfjMethod;
    private final ImagePointer pc;
    private final boolean jitMethod;
    private final U8Pointer bytecodePCOffset;
    private final J9MethodPointer j9method;
    private final DTFJJavaThread thread;
    private List<Object> roots = new LinkedList<Object>();

    public DTFJJavaStackFrame(DTFJJavaThread dtfjJavaThread, DTFJJavaMethod dtfjMethod, J9MethodPointer method, ImagePointer pc, ImagePointer basePointer, U8Pointer bytecodePCOffset, boolean jitted) {
        this.dtfjMethod = dtfjMethod;
        this.basePointer = basePointer;
        this.bytecodePCOffset = bytecodePCOffset;
        this.pc = pc;
        this.jitMethod = jitted;
        this.j9method = method;
        this.thread = dtfjJavaThread;
    }

    public ImagePointer getBasePointer() throws CorruptDataException {
        return this.basePointer;
    }

    public Iterator getHeapRoots() {
        return this.roots.iterator();
    }

    public JavaLocation getLocation() throws CorruptDataException {
        return this;
    }

    void addReference(Object object) {
        this.roots.add(object);
    }

    boolean isJitMethod() {
        return this.jitMethod;
    }

    public ImagePointer getAddress() throws CorruptDataException {
        return this.pc;
    }

    public int getCompilationLevel() throws CorruptDataException {
        return this.jitMethod ? 1 : 0;
    }

    public String getFilename() throws DataUnavailable, CorruptDataException {
        return this.dtfjMethod.getFilename();
    }

    public int getLineNumber() throws DataUnavailable, CorruptDataException {
        if (J9BuildFlags.opt_debugInfoServer) {
            int toReturn = 0;
            try {
                toReturn = OptInfo.getLineNumberForROMClass(this.j9method, UDATA.cast(this.bytecodePCOffset));
            }
            catch (Throwable t) {
                throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
            }
            if (toReturn < 0) {
                throw new DataUnavailable();
            }
            return toReturn;
        }
        throw new DataUnavailable();
    }

    public JavaMethod getMethod() throws CorruptDataException {
        return this.dtfjMethod;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DTFJJavaStackFrame) {
            DTFJJavaStackFrame other = (DTFJJavaStackFrame)obj;
            if (!other.basePointer.equals((Object)this.basePointer)) {
                return false;
            }
            if (!other.bytecodePCOffset.equals(this.bytecodePCOffset)) {
                return false;
            }
            if (!other.j9method.equals(this.j9method)) {
                return false;
            }
            if (!other.pc.equals((Object)this.pc)) {
                return false;
            }
            return other.jitMethod == this.jitMethod;
        }
        return false;
    }

    public int hashCode() {
        return this.basePointer.hashCode();
    }

    public String toString() {
        try {
            String className = "";
            try {
                className = this.dtfjMethod.getDeclaringClass().getName();
                className = className.replace("/", ".");
            }
            catch (DataUnavailable e) {
                className = "<class name unavailable>";
            }
            String methodName = this.dtfjMethod.getName();
            if (Modifier.isNative(this.dtfjMethod.getModifiers())) {
                return className + "." + methodName + "()";
            }
            String fileName = this.dtfjMethod.getFilename();
            int lineNumber = -1;
            try {
                lineNumber = this.getLineNumber();
            }
            catch (DataUnavailable dataUnavailable) {
                // empty catch block
            }
            if (lineNumber != -1) {
                return className + "." + methodName + "(" + fileName + ":" + lineNumber + ")";
            }
            return className + "." + methodName + "(" + fileName + ")";
        }
        catch (Throwable t) {
            J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
            return super.toString();
        }
    }
}

