/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders;

import com.ibm.j9ddr.corereaders.ILibraryResolver;
import com.ibm.j9ddr.corereaders.LibraryDataSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class ZipFileResolver
implements ILibraryResolver {
    private static Logger log = Logger.getLogger("com.ibm.j9ddr.library.path");
    private final File zipfile;
    private ArrayList<String> entryNames = null;
    private ZipFile zip = null;

    public ZipFileResolver(ImageInputStream stream) {
        URI uri = null;
        try {
            uri = new URI(stream.toString());
            if (uri.getFragment() != null && uri.getFragment().length() != 0) {
                uri = new URI(uri.getScheme() + "://" + uri.getPath());
            }
        }
        catch (URISyntaxException e) {
            log.log(Level.FINE, "Skipping zip resolver as the supplied stream was not a ZipMemoryCacheImageInputStream");
            this.zipfile = null;
            return;
        }
        this.zipfile = uri.getScheme().equals("file") ? new File(uri) : null;
    }

    @Override
    public LibraryDataSource getLibrary(String fileName, boolean silent) throws FileNotFoundException {
        if (this.zipfile == null) {
            throw new FileNotFoundException(fileName);
        }
        ZipEntry entry = null;
        try {
            this.zip = new ZipFile(this.zipfile);
            if (this.entryNames == null) {
                this.entryNames = new ArrayList();
                Enumeration<? extends ZipEntry> entries = this.zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry nextEntry = entries.nextElement();
                    this.entryNames.add(nextEntry.getName());
                    if (!nextEntry.getName().equals(fileName)) continue;
                    entry = nextEntry;
                }
                if (entry == null) {
                    throw new FileNotFoundException(fileName);
                }
            } else if (this.entryNames.contains(fileName)) {
                entry = this.zip.getEntry(fileName);
            } else {
                throw new FileNotFoundException(fileName);
            }
            MemoryCacheImageInputStream stream = new MemoryCacheImageInputStream(this.zip.getInputStream(entry));
            log.fine("Resolved library " + fileName + " in zip file " + this.zipfile.getAbsolutePath());
            return new LibraryDataSource(fileName, stream);
        }
        catch (IOException e) {
            log.log(Level.FINE, "Error resolving library in zip file " + this.zipfile.getAbsolutePath(), e);
            throw new FileNotFoundException(fileName + " (due to underlying IOException)");
        }
    }

    @Override
    public LibraryDataSource getLibrary(String fileName) throws FileNotFoundException {
        return this.getLibrary(fileName, true);
    }

    @Override
    public void dispose() {
        if (this.zip != null) {
            try {
                this.zip.close();
            }
            catch (IOException e) {
                log.log(Level.FINE, "Error closing zip file", e);
            }
        }
    }
}

