/* ----------------------------------------------------------------- */
/*           The Japanese TTS System "Open JTalk"                    */
/*           developed by HTS Working Group                          */
/*           http://open-jtalk.sourceforge.net/                      */
/* ----------------------------------------------------------------- */
/*                                                                   */
/*  Copyright (c) 2008-2014  Nagoya Institute of Technology          */
/*                           Department of Computer Science          */
/*                                                                   */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/* - Redistributions of source code must retain the above copyright  */
/*   notice, this list of conditions and the following disclaimer.   */
/* - Redistributions in binary form must reproduce the above         */
/*   copyright notice, this list of conditions and the following     */
/*   disclaimer in the documentation and/or other materials provided */
/*   with the distribution.                                          */
/* - Neither the name of the HTS working group nor the names of its  */
/*   contributors may be used to endorse or promote products derived */
/*   from this software without specific prior written permission.   */
/*                                                                   */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND            */
/* CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,       */
/* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF          */
/* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE          */
/* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS */
/* BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,          */
/* EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,     */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON */
/* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,   */
/* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY    */
/* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/* POSSIBILITY OF SUCH DAMAGE.                                       */
/* ----------------------------------------------------------------- */

#ifndef NJD_SET_UNVOICED_VOWEL_RULE_H
#define NJD_SET_UNVOICED_VOWEL_RULE_H

#ifdef __cplusplus
#define NJD_SET_UNVOICED_VOWEL_RULE_H_START extern "C" {
#define NJD_SET_UNVOICED_VOWEL_RULE_H_END   }
#else
#define NJD_SET_UNVOICED_VOWEL_RULE_H_START
#define NJD_SET_UNVOICED_VOWEL_RULE_H_END
#endif                          /* __CPLUSPLUS */

NJD_SET_UNVOICED_VOWEL_RULE_H_START;

/*
  q: k ky s sh t ty ch ts h f hy p py
  Rule 0 tB[͖Ȃ
  Rule 1 ́ułvƁu܂v́uv
  Rule 2 CĆuv͖₷
  Rule 3 ĖȂ
  Rule 4 ANZgjŖȂ
  Rule 5 q(k ky s sh t ty ch ts h f hy p py)Ɉ͂܂ꂽuivƁuuv
         OFs->s, s->sh, f->f, f->h, f->hy, h->f, h->h, h->hy
*/

#define NJD_SET_UNVOICED_VOWEL_FILLER "tB["
#define NJD_SET_UNVOICED_VOWEL_DOUSHI ""
#define NJD_SET_UNVOICED_VOWEL_JODOUSHI ""
#define NJD_SET_UNVOICED_VOWEL_JOSHI ""
#define NJD_SET_UNVOICED_VOWEL_KANDOUSHI ""
#define NJD_SET_UNVOICED_VOWEL_TOUTEN "A"
#define NJD_SET_UNVOICED_VOWEL_QUESTION "H"
#define NJD_SET_UNVOICED_VOWEL_QUOTATION "f"
#define NJD_SET_UNVOICED_VOWEL_SHI "V"
#define NJD_SET_UNVOICED_VOWEL_MA "}"
#define NJD_SET_UNVOICED_VOWEL_DE "f"
#define NJD_SET_UNVOICED_VOWEL_CHOUON "["
#define NJD_SET_UNVOICED_VOWEL_SU "X"

static const char *njd_set_unvoiced_vowel_candidate_list1[] = {
   "XB",                      /* s i */
   "X",                        /* s u */
   NULL
};

static const char *njd_set_unvoiced_vowel_next_mora_list1[] = {
   "J",                        /* k ky */
   "L",
   "N",
   "P",
   "R",
   "^",                        /* t ty ch ts */
   "`",
   "c",
   "e",
   "g",
   "n",                        /* h f hy */
   "q",
   "t",
   "w",
   "z",
   "p",                        /* p py */
   "s",
   "v",
   "y",
   "|",
   NULL
};

static const char *njd_set_unvoiced_vowel_candidate_list2[] = {
   "tB",                      /* f i */
   "q",                        /* h i */
   "t",                        /* f u */
   NULL
};

static const char *njd_set_unvoiced_vowel_next_mora_list2[] = {
   "J",                        /* k ky */
   "L",
   "N",
   "P",
   "R",
   "T",                        /* s sh */
   "V",
   "X",
   "Z",
   "\",
   "^",                        /* t ty ch ts */
   "`",
   "c",
   "e",
   "g",
   "p",                        /* p py */
   "s",
   "v",
   "y",
   "|",
   NULL
};

static const char *njd_set_unvoiced_vowel_candidate_list3[] = {
   "L",                      /* ky u */
   "V",                      /* sh u */
   "`",                      /* ch u */
   "cB",                      /* ts i */
   "q",                      /* hy u */
   "s",                      /* py u */
   "e",                      /* ty u */
   "gD",                      /* t u */
   "eB",                      /* t i */
   "L",                        /* k i */
   "N",                        /* k u */
   "V",                        /* sh i */
   "`",                        /* ch i */
   "c",                        /* ts u */
   "s",                        /* p i */
   "v",                        /* p u */
   NULL
};

static const char *njd_set_unvoiced_vowel_next_mora_list3[] = {
   "J",                        /* k ky */
   "L",
   "N",
   "P",
   "R",
   "T",                        /* s sh */
   "V",
   "X",
   "Z",
   "\",
   "^",                        /* t ty ch ts */
   "`",
   "c",
   "e",
   "g",
   "n",                        /* h f hy */
   "q",
   "t",
   "w",
   "z",
   "p",                        /* p py */
   "s",
   "v",
   "y",
   "|",
   NULL
};

static const char *njd_set_unvoiced_vowel_mora_list[] = {
   "",
   "",
   "",
   "H",
   "F",
   "B",
   "@",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "F",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "~",
   "~",
   "~",
   "~F",
   "~",
   "}",
   "|",
   "{",
   "z",
   "y",
   "x",
   "w",
   "v",
   "u",
   "tH",
   "tF",
   "tB",
   "t@",
   "t",
   "s",
   "s",
   "s",
   "sF",
   "s",
   "r",
   "r",
   "r",
   "rF",
   "r",
   "q",
   "q",
   "q",
   "qF",
   "q",
   "p",
   "o",
   "n",
   "m",
   "l",
   "k",
   "j",
   "j",
   "j",
   "jF",
   "j",
   "i",
   "hD",
   "h",
   "gD",
   "g",
   "f",
   "f",
   "f",
   "fF",
   "fB",
   "f",
   "e",
   "e",
   "e",
   "eF",
   "eB",
   "e",
   "d",
   "cH",
   "cF",
   "cB",
   "c@",
   "c",
   "b",
   "a",
   "`",
   "`",
   "`",
   "`F",
   "`",
   "_",
   "^",
   "]",
   "\",
   "[",
   "Z",
   "YB",
   "Y",
   "XB",
   "X",
   "W",
   "W",
   "W",
   "WF",
   "W",
   "V",
   "V",
   "V",
   "VF",
   "V",
   "U",
   "T",
   "S",
   "R",
   "Q",
   "P",
   "O",
   "N",
   "M",
   "M",
   "M",
   "MF",
   "M",
   "L",
   "L",
   "L",
   "LF",
   "L",
   "K",
   "J",
   "I",
   "H",
   "G",
   "F",
   "EH",
   "EF",
   "EB",
   "E",
   "D",
   "CF",
   "C",
   "B",
   "A",
   "@",
   "[",
   NULL
};

NJD_SET_UNVOICED_VOWEL_RULE_H_END;

#endif                          /* !NJD_SET_UNVOICED_VOWEL_RULE_H */
