/* ----------------------------------------------------------------- */
/*           The Japanese TTS System "Open JTalk"                    */
/*           developed by HTS Working Group                          */
/*           http://open-jtalk.sourceforge.net/                      */
/* ----------------------------------------------------------------- */
/*                                                                   */
/*  Copyright (c) 2008-2014  Nagoya Institute of Technology          */
/*                           Department of Computer Science          */
/*                                                                   */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/* - Redistributions of source code must retain the above copyright  */
/*   notice, this list of conditions and the following disclaimer.   */
/* - Redistributions in binary form must reproduce the above         */
/*   copyright notice, this list of conditions and the following     */
/*   disclaimer in the documentation and/or other materials provided */
/*   with the distribution.                                          */
/* - Neither the name of the HTS working group nor the names of its  */
/*   contributors may be used to endorse or promote products derived */
/*   from this software without specific prior written permission.   */
/*                                                                   */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND            */
/* CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,       */
/* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF          */
/* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE          */
/* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS */
/* BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,          */
/* EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,     */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON */
/* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,   */
/* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY    */
/* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/* POSSIBILITY OF SUCH DAMAGE.                                       */
/* ----------------------------------------------------------------- */

#ifndef NJD2JPCOMMON_RULE_H
#define NJD2JPCOMMON_RULE_H

#ifdef __cplusplus
#define NJD2JPCOMMON_RULE_H_START extern "C" {
#define NJD2JPCOMMON_RULE_H_END   }
#else
#define NJD2JPCOMMON_RULE_H_START
#define NJD2JPCOMMON_RULE_H_END
#endif                          /* __CPLUSPLUS */

NJD2JPCOMMON_RULE_H_START;

static const char *njd2jpcommon_pos_list[] = {
   "̑", "ԓ", "*", "*", "̑",
   "tB[", "*", "*", "*", "",
   "", "*", "*", "*", "",
   "L", "At@xbg", "*", "*", "L",
   "L", "", "*", "*", "L",
   "L", "ʊJ", "*", "*", "L",
   "L", "ʕ", "*", "*", "L",
   "L", "_", "*", "*", "L",
   "L", "", "*", "*", "L",
   "L", "Ǔ_", "*", "*", "L",
   "`e", "", "*", "*", "`e",
   "`e", "ڔ", "*", "*", "ڔ-`eI",
   "`e", "񎩗", "*", "*", "`e",
   "", "i", "", "*", "-i",
   "", "i", "p", "*", "-i",
   "", "i", "A", "*", "-i",
   "", "W", "*", "*", "-W",
   "", "I", "*", "*", "-I",
   "", "ڑ", "*", "*", "-ڑ",
   "", "", "*", "*", "-̑",
   "", "", "*", "*", "-̑",
   "", "", "*", "*", "-",
   "", "^^I", "*", "*", "-̑",
   "", "", "*", "*", "-̑",
   "", "Ả", "*", "*", "-̑",
   "", "*", "*", "*", "",
   "ڑ", "*", "*", "*", "ڑ",
   "ړ", "`eڑ", "*", "*", "ړ",
   "ړ", "ڑ", "*", "*", "ړ",
   "ړ", "ڑ", "*", "*", "ړ",
   "ړ", "ڑ", "*", "*", "ړ",
   "", "", "*", "*", "",
   "", "ڔ", "*", "*", "ڔ-I",
   "", "񎩗", "*", "*", "-񎩗",
   "", "*", "*", "*", "",
   "", "", "*", "*", "",
   "", "ސڑ", "*", "*", "",
   "", "Tϐڑ", "*", "*", "-Tϐڑ",
   "", "iC`eꊲ", "*", "*", "-ʖ",
   "", "", "*", "*", "-ʖ",
   "", "p", "*", "*", "-ʖ",
   "", "`eꊲ", "*", "*", "`",
   "", "ŗL", "", "*", "-ŗL",
   "", "ŗL", "l", "", "-ŗL",
   "", "ŗL", "l", "", "-ŗL",
   "", "ŗL", "l", "", "-ŗL",
   "", "ŗL", "gD", "*", "-ŗL",
   "", "ŗL", "n", "", "-ŗL",
   "", "ŗL", "n", "", "-ŗL",
   "", "", "*", "*", "-",
   "", "ڑI", "*", "*", "-ʖ",
   "", "ڔ", "Tϐڑ", "*", "ڔ-I",
   "", "ڔ", "", "*", "ڔ-I",
   "", "ڔ", "`eꊲ", "*", "ڔ-`󎌓I",
   "", "ڔ", "", "*", "ڔ-I",
   "", "ڔ", "ꊲ", "*", "ڔ-I",
   "", "ڔ", "l", "*", "ڔ-I",
   "", "ڔ", "n", "*", "ڔ-I",
   "", "ڔ", "", "*", "ڔ-I",
   "", "ڔ", "\", "*", "ڔ-I",
   "", "㖼", "", "*", "㖼",
   "", "㖼", "k", "*", "㖼",
   "", "񎩗I", "*", "*", "-ʖ",
   "", "", "ꊲ", "*", "-ʖ",
   "", "񎩗", "", "*", "-񎩗",
   "", "񎩗", "`eꊲ", "*", "-񎩗",
   "", "񎩗", "ꊲ", "*", "-񎩗",
   "", "񎩗", "\", "*", "-񎩗",
   "", "񎩗", "*", "*", "-񎩗",
   "", "\", "*", "*", "-ʖ",
   "A̎", "*", "*", "*", "A̎",
   NULL, NULL, NULL, NULL, NULL
};

static const char *njd2jpcommon_cform_list[] = {
   "*", "*",
   "Kڑ", "̑",
   "֊{`", "{`",
   "`", "`",
   "kP", "`",
   "kQ", "`",
   "{`", "{`",
   "{`-", "{`",
   "{`", "{`",
   "̌ڑ", "Ǎ`",
   "̌ڑ", "Ǎ`",
   "̌ڑQ", "Ǎ`",
   "{`", "{`",
   "REڑ", "R`",
   "Rkڑ", "R`",
   "Rڑ", "R`",
   "R`", "R`",
   "R", "R`",
   "߂", "ߌ`",
   "߂", "ߌ`",
   "߂", "ߌ`",
   "߂", "ߌ`",
   "ApSUCڑ", "Ap`",
   "Ap^ڑ", "Ap`",
   "Apeڑ", "Ap`",
   "Apfڑ", "Ap`",
   "Apjڑ", "Ap`",
   "Ap`", "Ap`",
   NULL, NULL
};

static const char *njd2jpcommon_ctype_list[] = {
   "*", "*",
   "JρEN", "Jsϊi",
   "JρE", "Jsϊi",
   "TρE|X", "Tsϊi",
   "TρE|Y", "Tsϊi",
   "TρEX", "Tsϊi",
   "", "sϊi",
   "i", "i",
   "iEN", "i",
   "iE", "i",
   "EJs", "i",
   "EKs", "i",
   "E^s", "i",
   "E_s", "i",
   "Ens", "i",
   "E}s", "i",
   "E", "i",
   "`eEAEIi", "`e",
   "`eECC", "`e",
   "`eECi", "`e",
   "ܒiEJsC", "ܒi",
   "ܒiEJs", "ܒi",
   "ܒiEJsփN", "ܒi",
   "ܒiEKs", "ܒi",
   "ܒiETs", "ܒi",
   "ܒiE^s", "ܒi",
   "ܒiEis", "ܒi",
   "ܒiEos", "ܒi",
   "ܒiE}s", "ܒi",
   "ܒiEs", "ܒi",
   "ܒiEsA", "ܒi",
   "ܒiEs", "ܒi",
   "ܒiEsE", "ܒi",
   "ܒiEs", "ܒi",
   "liETs", "li",
   "liE^s", "li",
   "liEns", "li",
   "liEos", "li",
   "E_s", "i",
   "Ens", "i",
   "EW", "",
   "E^", "",
   "E^C", "",
   "E_", "",
   "EfX", "",
   "EiC", "",
   "Ek", "",
   "E}X", "",
   "E", "",
   "sω^", "sω",
   "EL", "ꏕ",
   "EP", "ꏕ",
   "ESgV", "ꏕ",
   "Ei", "ꏕ",
   "ExV", "ꏕ",
   "E}W", "ꏕ",
   "E", "ꏕ",
   "E", "ꏕ",
   NULL, NULL
};

NJD2JPCOMMON_RULE_H_END;

#endif                          /* !NJD2JPCOMMON_RULE_H */
